/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.core.manager;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.bivrik.fancytoasts.core.Debug;
import net.bivrik.fancytoasts.core.IManager;
import net.bivrik.fancytoasts.platform.utility.ResourceLocations;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_320;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.slf4j.Logger;

public class SplashManager
implements IManager {
    private static final Logger LOGGER = Debug.getLogger(SplashManager.class);
    private static final class_2960 LOCATION = ResourceLocations.of("splashes.txt");
    private static final Random RANDOM = new Random();
    private class_320 user;
    private List<String> splashes;

    @Override
    public void onMinecraftInit(class_310 minecraft) {
        this.user = minecraft.method_1548();
        this.readSplashes(minecraft.method_1478());
    }

    private void readSplashes(class_3300 resourceManager) {
        try {
            Optional resource = resourceManager.method_14486(LOCATION);
            if (resource.isPresent()) {
                BufferedReader reader = new BufferedReader(((class_3298)resource.get()).method_43039());
                this.splashes = reader.lines().toList();
            } else {
                LOGGER.error("Could not start reading, because it does not exist");
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not access splash file: {}", (Object)e.getMessage());
        }
    }

    public String getSplash() {
        if (!this.splashes.isEmpty()) {
            String splash = this.splashes.get(RANDOM.nextInt(this.splashes.size()));
            if (splash.contains("{user.name}")) {
                splash = splash.replace("{user.name}", this.user.method_1676());
            }
            return splash;
        }
        LOGGER.error("Could not get splash, it is empty");
        return "";
    }
}

