/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.toast.animation;

import java.util.ArrayList;
import java.util.List;
import net.bivrik.fancytoasts.client.toast.FancyAdvancementToast;
import net.bivrik.fancytoasts.client.toast.animation.Appearance;
import net.bivrik.fancytoasts.client.toast.animation.FancyAdvancementSetup;
import net.bivrik.fancytoasts.client.toast.animation.FancyAdvancementToastAnimation;
import net.bivrik.fancytoasts.platform.utility.Colors;
import net.bivrik.fancytoasts.platform.utility.GUIs;
import net.bivrik.fancytoasts.utility.MathEasing;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.joml.Matrix3x2fStack;

public class OldlikeAnimation
extends FancyAdvancementToastAnimation {
    private static final Appearance ICON_APPEARANCE = new Appearance(2000, 0);
    private static final Appearance BANNER_APPEARANCE = new Appearance(2000, 100);
    private static final Appearance BACKGROUND_APPEARANCE = new Appearance(2000, 200);
    private static final Appearance TEXT_APPEARANCE = new Appearance(2000, 1200);
    private static final int FADE_OUT_DURATION = 3000;
    private static final int DURATION = 6500;
    private List<FormattedCharSequence> DESCRIPTION = new ArrayList<FormattedCharSequence>();

    @Override
    public void setup(FancyAdvancementSetup setup, FancyAdvancementToast toast) {
        super.setup(setup, toast);
        this.DESCRIPTION = toast.getMinecraft().font.split((FormattedText)setup.display().getDescription(), this.toast.getWidth() - 16);
    }

    @Override
    public void draw(GuiGraphics guiGraphics, Minecraft minecraft, long time) {
        float alpha;
        super.draw(guiGraphics, minecraft, time);
        float iconAppearProgress = ICON_APPEARANCE.getProgress(time);
        float bannerAppearProgress = BANNER_APPEARANCE.getProgress(time);
        float backgroundAppearProgress = BACKGROUND_APPEARANCE.getProgress(time);
        float textAppearProgress = TEXT_APPEARANCE.getProgress(time);
        float fadeOutProgress = Appearance.getProgress(time, 3000, 3500);
        Matrix3x2fStack stack = GUIs.getStack(guiGraphics);
        if (bannerAppearProgress > 0.0f) {
            GUIs.push(stack);
            alpha = 1.0f;
            float x = 0.0f;
            if (bannerAppearProgress != 1.0f) {
                alpha = MathEasing.easeOutLerp(0.0f, 1.0f, bannerAppearProgress);
                x = MathEasing.easeOutLerp(35, 0, bannerAppearProgress);
            } else if (fadeOutProgress > 0.0f) {
                alpha = MathEasing.easeInLerp(1.0f, 0.0f, fadeOutProgress);
            }
            float y = (float)(5.0 - Math.sin((float)time / 700.0f) * 2.0);
            GUIs.translate(stack, x, y);
            this.drawBanner(guiGraphics, alpha);
            GUIs.pop(stack);
        }
        if (backgroundAppearProgress > 0.0f) {
            GUIs.push(stack);
            alpha = 1.0f;
            int x = 0;
            if (backgroundAppearProgress != 1.0f) {
                alpha = MathEasing.easeOutLerp(0.0f, 1.0f, backgroundAppearProgress);
                x = MathEasing.easeOutLerp(35, 0, backgroundAppearProgress);
            } else if (fadeOutProgress > 0.0f) {
                alpha = MathEasing.easeInLerp(1.0f, 0.0f, fadeOutProgress);
            }
            GUIs.translate(stack, x, 0.0f);
            this.drawBackground(guiGraphics, alpha);
            GUIs.pop(stack);
        }
        if (iconAppearProgress > 0.0f) {
            GUIs.push(stack);
            alpha = 1.0f;
            int x = 77;
            float scale = 1.0f;
            if (iconAppearProgress != 1.0f) {
                alpha = MathEasing.easeOutLerp(0.0f, 1.0f, iconAppearProgress);
                x = MathEasing.easeOutLerp(115, 77, iconAppearProgress);
            } else if (fadeOutProgress > 0.0f) {
                alpha = MathEasing.easeInLerp(1.0f, 0.0f, fadeOutProgress);
                scale = MathEasing.easeInLerp(1.0f, 0.0f, fadeOutProgress);
            }
            GUIs.translate(stack, x, 11.0f);
            GUIs.rotateAround(stack, (float)(Math.cos((double)time / 500.0) * (double)0.2f), 81.0f, 14.0f);
            GUIs.scaleAround(stack, scale, 81.0f, 14.0f);
            this.drawIcon(guiGraphics, alpha);
            GUIs.pop(stack);
        }
        if (textAppearProgress > 0.0f) {
            int a2;
            int a;
            float secondTextAppearProgress = Math.max(0.0f, -0.1f + textAppearProgress * 1.1f);
            if (fadeOutProgress <= 0.0f) {
                a = Mth.floor((float)(textAppearProgress * 255.0f));
                a2 = Mth.floor((float)(secondTextAppearProgress * 255.0f));
            } else {
                float fadeOutText = MathEasing.easeInLerp(1.0f, 0.0f, fadeOutProgress) * 255.0f;
                a = Mth.floor((float)fadeOutText);
                a2 = Mth.floor((float)fadeOutText);
            }
            int titleColor = Colors.alpha(a, this.setup.titleColor());
            int toastColor = Colors.alpha(a2, this.setup.toastColor());
            int x = MathEasing.elasticEaseOutLerp(50, 0, textAppearProgress);
            int x2 = MathEasing.elasticEaseOutLerp(50, 0, secondTextAppearProgress);
            Font font = minecraft.font;
            guiGraphics.drawCenteredString(font, this.setup.display().getType().getDisplayName(), this.toast.getWidth() / 2 + x, 25, titleColor);
            if (!this.DESCRIPTION.isEmpty()) {
                guiGraphics.drawString(font, this.DESCRIPTION.get(0), 8 + x2, 38, toastColor);
                if (this.DESCRIPTION.size() > 1) {
                    FormattedCharSequence descriptionSecondLine = this.DESCRIPTION.get(1);
                    guiGraphics.drawString(font, descriptionSecondLine, 8 + x2, 47, toastColor);
                    if (this.DESCRIPTION.size() > 2) {
                        guiGraphics.drawString(font, "...", 8 + font.width(descriptionSecondLine) + x2, 47, toastColor);
                    }
                }
            }
        }
    }

    @Override
    public int getDuration() {
        return 6500;
    }

    @Override
    public int getToastSoundTiming() {
        return TEXT_APPEARANCE.startPoint() + TEXT_APPEARANCE.duration() / 5;
    }
}

