/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.gui;

import net.bivrik.fancytoasts.Common;
import net.bivrik.fancytoasts.client.config.ConfigHandler;
import net.bivrik.fancytoasts.client.config.ConfigTextureManager;
import net.bivrik.fancytoasts.client.config.ToastConfigData;
import net.bivrik.fancytoasts.client.gui.UniversalScreen;
import net.bivrik.fancytoasts.client.toast.texture.DisplayData;
import net.bivrik.fancytoasts.client.ui.InformationList;
import net.bivrik.fancytoasts.client.ui.ResourceLocationFilter;
import net.bivrik.fancytoasts.client.ui.ResourceLocationList;
import net.bivrik.fancytoasts.client.ui.SettingType;
import net.bivrik.fancytoasts.platform.utility.Components;
import net.minecraft.advancements.FrameType;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ToastConfigScreen
extends UniversalScreen {
    private final ToastConfigData toastConfigData;
    private SettingType settingType = SettingType.TEXTURES;
    private FrameType advancementType = FrameType.TASK;
    private DisplayData displayData = this.settingType.getDisplayData(Common.getConfigManager().getToastConfig().getTextureId());
    private Button doneButton;
    private Button backButton;
    private CycleButton<SettingType> settingTypeCycButton;
    private CycleButton<ResourceLocationFilter> resourceLocationFilterCycButton;
    private CycleButton<FrameType> advancementTypeCycButton;
    private EditBox editBox;
    private ResourceLocationList locationsList;
    private InformationList infoList;
    private ResourceLocationFilter filter = ResourceLocationFilter.A_Z;

    public ToastConfigScreen(Screen parent) {
        super(Components.of("gui.config.customization_title"), parent);
        this.toastConfigData = Common.getConfigManager().getToastConfig();
        ConfigTextureManager.reload();
    }

    public FrameType getAdvancementType() {
        return this.advancementType;
    }

    public ToastConfigData getConfigData() {
        return this.toastConfigData;
    }

    protected void m_7856_() {
        this.doneButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.done()).m_252987_(this.f_96543_ / 2 + 100 - 125 + 4, this.f_96544_ - 26, 150, 20).m_253136_());
        this.backButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130660_, button -> this.toParentScreen()).m_252987_(this.f_96543_ / 2 - 125 - 4, this.f_96544_ - 20 - 6, 100, 20).m_253136_());
        this.advancementTypeCycButton = CycleButton.m_168894_(this::getAdvancementTypeDisplayName).m_168929_().m_168961_((Object[])FrameType.values()).m_168948_((Object)this.advancementType).m_232498_(advancementType -> Tooltip.m_257550_((Component)Component.m_237115_((String)("fancytoasts.gui.tooltip." + advancementType.m_15548_())))).m_168936_(8, 32, 80, 20, (Component)Component.m_237119_(), (button, value) -> this.setAdvancementType((FrameType)value));
        this.locationsList = (ResourceLocationList)this.m_142416_((GuiEventListener)new ResourceLocationList(this.f_96541_, this.f_96543_ / 2 + 60 - 8, this.f_96544_ - 20 - 8 - 64 - 2, this.f_96543_ / 2 - 60, 60, 18, this.settingType));
        this.locationsList.setAcceptResponder(this::onAcceptedEntry);
        this.locationsList.setSelectResponder(this::onSelectedEntry);
        this.infoList = (InformationList)this.m_142416_((GuiEventListener)new InformationList(this.f_96541_, this.f_96543_ / 2 - 60 - 16, this.f_96544_ - 20 - 8 - 64 - 2, 8, 60, this.displayData, this.settingType.getCurrentId(this).m_214298_().contains("config")));
        this.editBox = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.f_96543_ / 2 - 60, 32, this.f_96543_ / 2 - 40 - 30 - 32, 20, this.editBox, (Component)Component.m_237113_((String)"...")));
        this.editBox.m_94151_(this.locationsList::onSearchUpdate);
        this.resourceLocationFilterCycButton = (CycleButton)this.m_142416_((GuiEventListener)CycleButton.m_168894_(ResourceLocationFilter::getDisplayName).m_168929_().m_168961_((Object[])ResourceLocationFilter.values()).m_168948_((Object)this.filter).m_168936_(this.f_96543_ - 80 - 16 - 60, 32, 60, 20, (Component)Component.m_237119_(), (button, value) -> this.setFilter((ResourceLocationFilter)((Object)value))));
        this.settingTypeCycButton = (CycleButton)this.m_142416_((GuiEventListener)CycleButton.m_168894_(SettingType::getDisplayName).m_168929_().m_168961_((Object[])SettingType.values()).m_168948_((Object)this.settingType).m_232498_(settingType -> Tooltip.m_257550_((Component)Component.m_237115_((String)("fancytoasts.gui.tooltip." + settingType.getName())))).m_168936_(this.f_96543_ - 88, 32, 80, 20, (Component)Component.m_237119_(), (button, value) -> this.setSettingType((SettingType)((Object)value))));
        this.setFilter(this.filter);
        this.tryAddAdvancementTypeCycButton();
    }

    private Component getAdvancementTypeDisplayName(FrameType type) {
        return Component.m_237115_((String)("fancytoasts.gui.label." + type.m_15548_()));
    }

    private void done() {
        ConfigHandler.save(this.toastConfigData);
        this.toParentScreen();
    }

    @Override
    protected void toParentScreen() {
        ResourceLocation textureId = Common.getConfigManager().getToastConfig().getTextureId();
        ConfigTextureManager.releaseTexturesFromMinecraft();
        if (textureId.m_214298_().contains("config")) {
            ConfigTextureManager.registerInMinecraft(textureId);
        }
        super.toParentScreen();
    }

    private void setFilter(ResourceLocationFilter filter) {
        this.editBox.m_94144_("");
        this.locationsList.onFilterUpdate(filter);
        this.filter = filter;
    }

    private void setSettingType(SettingType type) {
        this.settingType = type;
        this.editBox.m_94144_("");
        this.locationsList.setResourceLocations(this.settingType);
        this.locationsList.onFilterUpdate(this.filter);
        this.tryAddAdvancementTypeCycButton();
    }

    private void tryAddAdvancementTypeCycButton() {
        if (this.settingType == SettingType.SOUNDS) {
            this.advancementType = FrameType.TASK;
            this.advancementTypeCycButton.m_168892_((Object)this.advancementType);
            this.m_142416_((GuiEventListener)this.advancementTypeCycButton);
        } else {
            this.m_169411_((GuiEventListener)this.advancementTypeCycButton);
        }
        this.infoList.update(this.settingType.getDisplayData(this.settingType.getCurrentId(this)), this.settingType.getCurrentId(this).m_214298_().contains("config"), true);
    }

    private void setAdvancementType(FrameType type) {
        this.advancementType = type;
        this.infoList.update(this.settingType.getDisplayData(this.settingType.getCurrentId(this)), this.settingType.getCurrentId(this).m_214298_().contains("config"), true);
    }

    private void onAcceptedEntry(ResourceLocation location) {
        this.settingType.apply(this, location);
        this.infoList.update(this.displayData, this.settingType.getCurrentId(this).m_214298_().contains("config"), true);
    }

    private void onSelectedEntry(ResourceLocation location) {
        this.displayData = this.settingType.getDisplayData(location);
        boolean isCurrent = this.settingType.getCurrentId(this).equals((Object)location);
        this.infoList.update(this.displayData, location.m_214298_().contains("config"), isCurrent);
    }
}

