/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.toast;

import java.util.Objects;
import net.bivrik.fancytoasts.Common;
import net.bivrik.fancytoasts.Debug;
import net.bivrik.fancytoasts.client.toast.ToastAnimationRegistry;
import net.bivrik.fancytoasts.client.toast.animation.FancyAdvancementSetup;
import net.bivrik.fancytoasts.client.toast.animation.FancyAdvancementToastAnimation;
import net.bivrik.fancytoasts.client.toast.texture.TextureUV;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class FancyAdvancementToast {
    private static final int WIDTH = 162;
    private static final int HEIGHT = 70;
    private final FancyAdvancementToastAnimation animation;
    private final ResourceLocation toastSoundId;
    private final float volume;
    private SoundManager soundManager;
    private boolean isEnded = false;
    private long time;
    private int playedSoundsCount = 0;

    public FancyAdvancementToast(Advancement advancement, ResourceLocation texture, ResourceLocation animationId) {
        DisplayInfo display = advancement.m_138320_();
        this.animation = ToastAnimationRegistry.getAnimation(animationId).get();
        switch (Objects.requireNonNull(display).m_14992_()) {
            case TASK: {
                this.animation.setup(new FancyAdvancementSetup(texture, TextureUV.TASK_FRAME_UV, display, -256, -1), this);
                this.toastSoundId = Common.getConfigManager().getToastConfig().getSoundId(FrameType.TASK);
                this.volume = Common.getConfigManager().getGeneralConfig().getTaskVolume();
                break;
            }
            case GOAL: {
                this.animation.setup(new FancyAdvancementSetup(texture, TextureUV.GOAL_FRAME_UV, display, -14483457, -1), this);
                this.toastSoundId = Common.getConfigManager().getToastConfig().getSoundId(FrameType.GOAL);
                this.volume = Common.getConfigManager().getGeneralConfig().getGoalVolume();
                break;
            }
            case CHALLENGE: {
                this.animation.setup(new FancyAdvancementSetup(texture, TextureUV.CHALLENGE_FRAME_UV, display, -377606, -14483457), this);
                this.toastSoundId = Common.getConfigManager().getToastConfig().getSoundId(FrameType.CHALLENGE);
                this.volume = Common.getConfigManager().getGeneralConfig().getChallengeVolume();
                break;
            }
            default: {
                throw new RuntimeException("Could match correct advancement type");
            }
        }
        Debug.info("Created new Fancy Advancement Toast: {}", display.m_14977_().getString());
    }

    public void draw(GuiGraphics graphics, Minecraft minecraft) {
        this.animation.draw(graphics, minecraft, this.time);
    }

    public void update(long time) {
        this.time = time;
        if (this.time >= (long)this.animation.getDuration()) {
            this.isEnded = true;
        }
        if (this.soundManager != null) {
            int timeInSeconds = (int)(this.time / 50L);
            if (this.playedSoundsCount == 0 && timeInSeconds == this.animation.getToastSoundTiming() / 50) {
                SoundEvent tse = SoundEvent.m_262856_((ResourceLocation)this.toastSoundId, (float)0.0f);
                this.soundManager.m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)tse, (float)1.0f, (float)this.volume));
                ++this.playedSoundsCount;
            }
            if (this.playedSoundsCount == 1 && timeInSeconds == this.animation.getDuration() / 50 - 10) {
                this.soundManager.m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12497_, (float)1.0f, (float)1.5f));
                ++this.playedSoundsCount;
            }
        }
    }

    public void trySetSoundManager(SoundManager soundManager) {
        if (!Common.getConfigManager().getGeneralConfig().areSoundsEnabled()) {
            return;
        }
        this.soundManager = soundManager;
        this.soundManager.m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12497_, (float)1.0f, (float)1.5f));
    }

    public Minecraft getMinecraft() {
        return Minecraft.m_91087_();
    }

    public boolean isEnded() {
        return this.isEnded;
    }

    public int getWidth() {
        return 162;
    }

    public int getHeight() {
        return 70;
    }
}

