/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.toast.animation;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.bivrik.fancytoasts.client.toast.FancyAdvancementToast;
import net.bivrik.fancytoasts.client.toast.animation.Appearance;
import net.bivrik.fancytoasts.client.toast.animation.FancyAdvancementSetup;
import net.bivrik.fancytoasts.client.toast.animation.FancyAdvancementToastAnimation;
import net.bivrik.fancytoasts.platform.utility.Colors;
import net.bivrik.fancytoasts.platform.utility.GUIs;
import net.bivrik.fancytoasts.utility.MathEasing;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class StandardAnimation
extends FancyAdvancementToastAnimation {
    private final Appearance ICON_APPEARANCE = new Appearance(2000, 0);
    private final Appearance BANNER_APPEARANCE = new Appearance(500, 1500);
    private final Appearance BACKGROUND_APPEARANCE = new Appearance(800, 1600);
    private final Appearance TEXT_APPEARANCE = new Appearance(1000, 2000);
    private final int FADE_OUT_DURATION = 2000;
    private final int DURATION = 8000;
    private List<FormattedCharSequence> DESCRIPTION = new ArrayList<FormattedCharSequence>();

    @Override
    public void setup(FancyAdvancementSetup setup, FancyAdvancementToast toast) {
        super.setup(setup, toast);
        this.DESCRIPTION = toast.getMinecraft().f_91062_.m_92923_((FormattedText)setup.display().m_14977_(), this.toast.getWidth() - 20);
    }

    @Override
    public void draw(GuiGraphics guiGraphics, Minecraft minecraft, long time) {
        super.draw(guiGraphics, minecraft, time);
        float iconAppearProgress = this.ICON_APPEARANCE.getProgress(time);
        float bannerAppearProgress = this.BANNER_APPEARANCE.getProgress(time);
        float backgroundAppearProgress = this.BACKGROUND_APPEARANCE.getProgress(time);
        float textAppearProgress = this.TEXT_APPEARANCE.getProgress(time);
        float fadeOutProgress = Appearance.getProgress(time, 2000, 6000);
        PoseStack stack = GUIs.getStack(guiGraphics);
        if (fadeOutProgress > 0.0f) {
            float fadeOutY = MathEasing.easeInLerp(0, -80, fadeOutProgress);
            GUIs.push(stack);
            GUIs.translate(stack, 0.0f, fadeOutY);
        }
        if (backgroundAppearProgress > 0.0f) {
            GUIs.push(stack);
            if (backgroundAppearProgress != 1.0f) {
                int y = MathEasing.easeOutLerp(-200, 0, backgroundAppearProgress);
                GUIs.translate(stack, 0.0f, y);
            }
            this.drawBackground(guiGraphics);
            GUIs.pop(stack);
        }
        if (bannerAppearProgress > 0.0f) {
            GUIs.push(stack);
            if (bannerAppearProgress != 1.0f) {
                float xScale = MathEasing.easeOutLerp(0.0f, 1.0f, bannerAppearProgress);
                GUIs.scaleAround(stack, xScale, 1.0f, 81.0f, 0.0f);
            }
            this.drawBanner(guiGraphics);
            GUIs.pop(stack);
        }
        if (iconAppearProgress > 0.0f) {
            GUIs.push(stack);
            if (iconAppearProgress != 1.0f) {
                int y = MathEasing.easeOutLerp(-100, 0, iconAppearProgress);
                float scale = MathEasing.easeOutLerp(0.0f, 1.0f, iconAppearProgress);
                GUIs.scaleAround(stack, scale, 81.0f, 13.0f);
                GUIs.translate(stack, 0.0f, y);
            }
            GUIs.translate(stack, 0.0f, (float)(Math.sin((float)time / 500.0f) * 1.5) - 5.0f);
            this.drawIcon(guiGraphics);
            GUIs.pop(stack);
        }
        if (textAppearProgress > 0.05f) {
            int a = Mth.m_14143_((float)(textAppearProgress * 255.0f));
            int titleColor = Colors.alpha(a, this.setup.titleColor());
            int toastColor = Colors.alpha(a, this.setup.toastColor());
            Font font = minecraft.f_91062_;
            DisplayInfo display = this.setup.display();
            guiGraphics.m_280653_(font, display.m_14992_().m_15553_(), this.toast.getWidth() / 2, 25, titleColor);
            if (!this.DESCRIPTION.isEmpty()) {
                if (this.DESCRIPTION.size() == 1) {
                    guiGraphics.m_280364_(font, this.DESCRIPTION.get(0), this.toast.getWidth() / 2, 43, toastColor);
                } else {
                    int lineHeight = 42 - 9 * (this.DESCRIPTION.size() - 1) / 2;
                    for (FormattedCharSequence text : this.DESCRIPTION) {
                        guiGraphics.m_280364_(font, text, this.toast.getWidth() / 2, lineHeight, toastColor);
                        lineHeight += 9;
                    }
                }
            }
        }
        if (fadeOutProgress > 0.0f) {
            GUIs.pop(stack);
        }
    }

    @Override
    public int getDuration() {
        return 8000;
    }

    @Override
    public int getToastSoundTiming() {
        return this.TEXT_APPEARANCE.startPoint();
    }
}

