/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.bivrik.fancytoasts.Debug;
import net.bivrik.fancytoasts.platform.utility.ResourceLocations;
import net.minecraft.client.User;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class SplashManager {
    private static final ResourceLocation LOCATION = ResourceLocations.of("splashes.txt");
    private static final Random rnd = new Random();
    private final User user;
    private List<String> splashes;

    public SplashManager(User user) {
        this.user = user;
    }

    public void load(ResourceManager resourceManager) {
        try {
            Optional resource = resourceManager.m_213713_(LOCATION);
            if (resource.isPresent()) {
                BufferedReader reader = new BufferedReader(((Resource)resource.get()).m_215508_());
                this.splashes = reader.lines().toList();
            } else {
                Debug.error("Could not start reading, because it is not exist");
            }
        }
        catch (IOException e) {
            Debug.error("Could not read or get splash file. Error: {}", e);
        }
    }

    public String getSplash() {
        if (!this.splashes.isEmpty()) {
            String splash = this.splashes.get(rnd.nextInt(this.splashes.size()));
            if (splash.contains("{user.name}")) {
                splash = splash.replace("{user.name}", this.user.m_92546_());
            }
            return splash;
        }
        Debug.error("Could not get splash, it is empty");
        return "";
    }
}

