/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client;

import java.util.ArrayList;
import java.util.List;
import net.bivrik.fancytoasts.Debug;
import net.bivrik.fancytoasts.client.KeyBinding;
import net.minecraft.client.KeyMapping;

public class KeyBindingManager {
    private final List<KeyBinding> KEY_BINDINGS = new ArrayList<KeyBinding>();

    public void registerKey(String name, int keyCode, KeyBinding.KeyExecutor executor) {
        KeyMapping key = new KeyMapping((String)(name = "key.fancytoasts." + (String)name), keyCode, "key.categories.misc");
        KeyBinding bind = new KeyBinding(key, executor);
        if (this.KEY_BINDINGS.contains(bind)) {
            Debug.warn("{} already exists, could not add", name);
            return;
        }
        this.KEY_BINDINGS.add(bind);
        Debug.info("Registered {}", name);
    }

    public KeyMapping[] getUpdatedKeys(KeyMapping[] builtinKeys) {
        ArrayList<KeyMapping> keys = new ArrayList<KeyMapping>(List.of(builtinKeys));
        for (KeyBinding keyBinding : this.KEY_BINDINGS) {
            keys.add(keyBinding.key());
        }
        return keys.toArray(new KeyMapping[0]);
    }

    public void tick() {
        for (KeyBinding binding : this.KEY_BINDINGS) {
            if (!binding.key().consumeClick()) continue;
            binding.executor().execute();
        }
    }
}

