/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.platform.utility;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.bivrik.fancytoasts.platform.utility.Colors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public class GUIs {
    public static void translate(PoseStack stack, float x, float y, float z) {
        stack.translate(x, y, z);
    }

    public static void translate(PoseStack stack, float x, float y) {
        GUIs.translate(stack, x, y, 0.0f);
    }

    public static void scaleAround(PoseStack stack, float sx, float sy, float ox, float oy) {
        stack.translate(ox, oy, 0.0f);
        stack.scale(sx, sy, 1.0f);
        stack.translate(-ox, -oy, 0.0f);
    }

    public static void scaleAround(PoseStack stack, float scale, float ox, float oy) {
        stack.translate(ox, oy, 0.0f);
        stack.scale(scale, scale, 1.0f);
        stack.translate(-ox, -oy, 0.0f);
    }

    public static void rotateAround(PoseStack stack, float rotation, float ox, float oy) {
        stack.translate(ox, oy, 0.0f);
        stack.mulPose(Axis.ZP.rotation(rotation));
        stack.translate(-ox, -oy, 0.0f);
    }

    public static PoseStack getStack(GuiGraphics guiGraphics) {
        return guiGraphics.pose();
    }

    public static void push(PoseStack stack) {
        stack.pushPose();
    }

    public static void pop(PoseStack stack) {
        stack.popPose();
    }

    public static void drawTransparentGUITexture(GuiGraphics graphics, ResourceLocation atlas, int x, int y, int u, int v, int width, int height, float alpha) {
        graphics.blit(RenderType::guiTextured, atlas, x, y, (float)u, (float)v, width, height, 256, 256, Colors.alpha((int)(alpha * 255.0f), -1));
    }
}

