/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.config;

import net.bivrik.fancytoasts.client.config.AdvancementToastPosition;
import net.bivrik.fancytoasts.client.config.AdvancementToastScreenBehavior;
import net.bivrik.fancytoasts.client.config.ConfigData;
import net.bivrik.fancytoasts.platform.Services;

public class GeneralConfigData
extends ConfigData {
    private boolean isJadeCompatEnabled;
    private boolean areSoundsEnabled;
    private float taskVolume;
    private float goalVolume;
    private float challengeVolume;
    private AdvancementToastPosition position;
    private AdvancementToastScreenBehavior screenBehavior;

    public GeneralConfigData(boolean isJadeCompatEnabled, boolean areSoundsEnabled, float taskVolume, float goalVolume, float challengeVolume, AdvancementToastPosition position, AdvancementToastScreenBehavior screenBehavior) {
        super("./config/fancytoasts/general.json");
        this.isJadeCompatEnabled = isJadeCompatEnabled;
        this.areSoundsEnabled = areSoundsEnabled;
        this.taskVolume = taskVolume;
        this.goalVolume = goalVolume;
        this.challengeVolume = challengeVolume;
        this.position = position;
        this.screenBehavior = screenBehavior;
    }

    public GeneralConfigData() {
        super("./config/fancytoasts/general.json");
        this.isJadeCompatEnabled = true;
        this.areSoundsEnabled = true;
        this.taskVolume = 1.0f;
        this.goalVolume = 1.0f;
        this.challengeVolume = 1.0f;
        this.position = AdvancementToastPosition.CENTER;
        this.screenBehavior = AdvancementToastScreenBehavior.TRANSPARENT;
    }

    public boolean isJadeCompatEnabled() {
        return this.isJadeCompatEnabled;
    }

    public void setJadeCompatEnabled(boolean isJadeCompatibility) {
        this.isJadeCompatEnabled = isJadeCompatibility;
        if (!this.isJadeCompatEnabled) {
            Services.PLATFORM.tryEnableJade();
        } else {
            Services.PLATFORM.tryDisableJade();
        }
    }

    public boolean areSoundsEnabled() {
        return this.areSoundsEnabled;
    }

    public void setSoundsEnabled(boolean areSoundsEnabled) {
        this.areSoundsEnabled = areSoundsEnabled;
    }

    public float getTaskVolume() {
        return this.taskVolume;
    }

    public void setTaskVolume(float taskVolume) {
        this.taskVolume = taskVolume;
    }

    public float getGoalVolume() {
        return this.goalVolume;
    }

    public void setGoalVolume(float goalVolume) {
        this.goalVolume = goalVolume;
    }

    public float getChallengeVolume() {
        return this.challengeVolume;
    }

    public void setChallengeVolume(float challengeVolume) {
        this.challengeVolume = challengeVolume;
    }

    public AdvancementToastPosition getPosition() {
        return this.position;
    }

    public void setPosition(AdvancementToastPosition position) {
        this.position = position;
    }

    public AdvancementToastScreenBehavior getScreenBehavior() {
        return this.screenBehavior;
    }

    public void setScreenBehavior(AdvancementToastScreenBehavior screenBehavior) {
        this.screenBehavior = screenBehavior;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public GeneralConfigData get() {
        return new GeneralConfigData(this.isJadeCompatEnabled, this.areSoundsEnabled, this.taskVolume, this.goalVolume, this.challengeVolume, this.position, this.screenBehavior);
    }

    @Override
    public String toString() {
        return super.toString().replace("}", ", ") + String.format("isJadeCompatibility='%s', areSoundsEnabled='%s', taskVolume='%s', goalVolume='%s', challengeVolume='%s', advancementToastPosition='%s', advancementToastScreenBehavior='%s'}", new Object[]{this.isJadeCompatEnabled, this.areSoundsEnabled, Float.valueOf(this.taskVolume), Float.valueOf(this.goalVolume), Float.valueOf(this.challengeVolume), this.position, this.screenBehavior});
    }
}

