/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.gui;

import net.bivrik.fancytoasts.Common;
import net.bivrik.fancytoasts.client.config.ConfigHandler;
import net.bivrik.fancytoasts.client.config.ConfigTextureManager;
import net.bivrik.fancytoasts.client.config.ToastConfigData;
import net.bivrik.fancytoasts.client.gui.UniversalScreen;
import net.bivrik.fancytoasts.client.toast.texture.DisplayData;
import net.bivrik.fancytoasts.client.ui.InformationList;
import net.bivrik.fancytoasts.client.ui.ResourceLocationFilter;
import net.bivrik.fancytoasts.client.ui.ResourceLocationList;
import net.bivrik.fancytoasts.client.ui.SettingType;
import net.bivrik.fancytoasts.platform.utility.Components;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ToastConfigScreen
extends UniversalScreen {
    private final ToastConfigData toastConfigData;
    private SettingType settingType = SettingType.TEXTURES;
    private AdvancementType advancementType = AdvancementType.TASK;
    private DisplayData displayData = this.settingType.getDisplayData(Common.getConfigManager().getToastConfig().getTextureId());
    private Button doneButton;
    private Button backButton;
    private CycleButton<SettingType> settingTypeCycButton;
    private CycleButton<ResourceLocationFilter> resourceLocationFilterCycButton;
    private CycleButton<AdvancementType> advancementTypeCycButton;
    private EditBox editBox;
    private ResourceLocationList locationsList;
    private InformationList infoList;
    private ResourceLocationFilter filter = ResourceLocationFilter.A_Z;

    public ToastConfigScreen(Screen parent) {
        super(Components.of("gui.config.customization_title"), parent);
        this.toastConfigData = Common.getConfigManager().getToastConfig();
        ConfigTextureManager.reload();
    }

    public AdvancementType getAdvancementType() {
        return this.advancementType;
    }

    public ToastConfigData getConfigData() {
        return this.toastConfigData;
    }

    protected void init() {
        this.doneButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.done()).bounds(this.width / 2 + 100 - 125 + 4, this.height - 26, 150, 20).build());
        this.backButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_BACK, button -> this.toParentScreen()).bounds(this.width / 2 - 125 - 4, this.height - 20 - 6, 100, 20).build());
        this.settingTypeCycButton = (CycleButton)this.addRenderableWidget((GuiEventListener)CycleButton.builder(SettingType::getDisplayName).displayOnlyValue().withValues((Object[])SettingType.values()).withInitialValue((Object)this.settingType).withTooltip(settingType -> Tooltip.create((Component)Component.translatable((String)("fancytoasts.gui.tooltip." + settingType.getName())))).create(this.width - 88, 32, 80, 20, (Component)Component.empty(), (button, value) -> this.setSettingType((SettingType)((Object)value))));
        this.advancementTypeCycButton = CycleButton.builder(this::getAdvancementTypeDisplayName).displayOnlyValue().withValues((Object[])AdvancementType.values()).withInitialValue((Object)this.advancementType).withTooltip(advancementType -> Tooltip.create((Component)Component.translatable((String)("fancytoasts.gui.tooltip." + advancementType.getSerializedName())))).create(8, 32, 80, 20, (Component)Component.empty(), (button, value) -> this.setAdvancementType((AdvancementType)value));
        this.locationsList = (ResourceLocationList)this.addRenderableWidget((GuiEventListener)new ResourceLocationList(this.minecraft, this.width / 2 + 60 - 8, this.height - 20 - 8 - 64 - 2, this.width / 2 - 60, 60, 18, this.settingType));
        this.locationsList.setAcceptResponder(this::onAcceptedEntry);
        this.locationsList.setSelectResponder(this::onSelectedEntry);
        this.infoList = (InformationList)this.addRenderableWidget((GuiEventListener)new InformationList(this.minecraft, this.width / 2 - 60 - 16, this.height - 20 - 8 - 64 - 2, 8, 60, this.displayData, this.settingType.getCurrentId(this).toLanguageKey().contains("config")));
        this.editBox = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.width / 2 - 60, 32, this.width / 2 - 40 - 30 - 32, 20, this.editBox, (Component)Component.literal((String)"...")));
        this.editBox.setResponder(this.locationsList::onSearchUpdate);
        this.resourceLocationFilterCycButton = (CycleButton)this.addRenderableWidget((GuiEventListener)CycleButton.builder(ResourceLocationFilter::getDisplayName).displayOnlyValue().withValues((Object[])ResourceLocationFilter.values()).withInitialValue((Object)this.filter).create(this.width - 80 - 16 - 60, 32, 60, 20, (Component)Component.empty(), (button, value) -> this.setFilter((ResourceLocationFilter)((Object)value))));
        this.setFilter(this.filter);
        this.tryAddAdvancementTypeCycButton();
    }

    private Component getAdvancementTypeDisplayName(AdvancementType type) {
        return Component.translatable((String)("fancytoasts.gui.label." + type.getSerializedName()));
    }

    private void done() {
        ConfigHandler.save(this.toastConfigData);
        this.toParentScreen();
    }

    @Override
    protected void toParentScreen() {
        ResourceLocation textureId = Common.getConfigManager().getToastConfig().getTextureId();
        ConfigTextureManager.releaseTexturesFromMinecraft();
        if (textureId.toLanguageKey().contains("config")) {
            ConfigTextureManager.registerInMinecraft(textureId);
        }
        super.toParentScreen();
    }

    private void setFilter(ResourceLocationFilter filter) {
        this.editBox.setValue("");
        this.locationsList.onFilterUpdate(filter);
        this.filter = filter;
    }

    private void setSettingType(SettingType type) {
        this.settingType = type;
        this.editBox.setValue("");
        this.locationsList.setResourceLocations(this.settingType);
        this.locationsList.onFilterUpdate(this.filter);
        this.tryAddAdvancementTypeCycButton();
    }

    private void tryAddAdvancementTypeCycButton() {
        if (this.settingType == SettingType.SOUNDS) {
            this.advancementType = AdvancementType.TASK;
            this.advancementTypeCycButton.setValue((Object)this.advancementType);
            this.addRenderableWidget((GuiEventListener)this.advancementTypeCycButton);
        } else {
            this.removeWidget((GuiEventListener)this.advancementTypeCycButton);
        }
        this.infoList.update(this.settingType.getDisplayData(this.settingType.getCurrentId(this)), this.settingType.getCurrentId(this).toLanguageKey().contains("config"), true);
    }

    private void setAdvancementType(AdvancementType type) {
        this.advancementType = type;
        this.infoList.update(this.settingType.getDisplayData(this.settingType.getCurrentId(this)), this.settingType.getCurrentId(this).toLanguageKey().contains("config"), true);
    }

    private void onAcceptedEntry(ResourceLocation location) {
        this.settingType.apply(this, location);
        this.infoList.update(this.displayData, this.settingType.getCurrentId(this).toLanguageKey().contains("config"), true);
    }

    private void onSelectedEntry(ResourceLocation location) {
        this.displayData = this.settingType.getDisplayData(location);
        boolean isCurrent = this.settingType.getCurrentId(this).equals((Object)location);
        this.infoList.update(this.displayData, location.toLanguageKey().contains("config"), isCurrent);
    }
}

