/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.toast.animation;

import net.bivrik.fancytoasts.Common;
import net.bivrik.fancytoasts.client.config.AdvancementToastScreenBehavior;
import net.bivrik.fancytoasts.client.toast.FancyAdvancementToast;
import net.bivrik.fancytoasts.client.toast.animation.FancyAdvancementSetup;
import net.bivrik.fancytoasts.client.toast.texture.TextureUV;
import net.bivrik.fancytoasts.platform.utility.GUIs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

public abstract class FancyAdvancementToastAnimation {
    protected FancyAdvancementSetup setup;
    protected FancyAdvancementToast toast;
    private float guiAlpha;

    public void setup(FancyAdvancementSetup setup, FancyAdvancementToast toast) {
        this.setup = setup;
        this.toast = toast;
    }

    public void draw(GuiGraphics guiGraphics, Minecraft minecraft, long time) {
        this.guiAlpha = Common.getAdvancementToastManager().isScreenOpened() && Common.getConfigManager().getGeneralConfig().getScreenBehavior() == AdvancementToastScreenBehavior.TRANSPARENT ? 0.5f : 1.0f;
    }

    public abstract int getDuration();

    public abstract int getToastSoundTiming();

    protected void drawIcon(GuiGraphics graphics, float alpha) {
        TextureUV frameUV = this.setup.uvs().frame();
        GUIs.drawGUITexture(graphics, this.setup.texture(), 68, 0, frameUV.u(), frameUV.v(), 26, 26, alpha * this.guiAlpha);
        graphics.renderFakeItem(this.setup.display().getIcon(), 73, 5);
    }

    protected void drawIcon(GuiGraphics guiGraphics) {
        this.drawIcon(guiGraphics, 1.0f);
    }

    protected void drawBanner(GuiGraphics graphics, float alpha) {
        TextureUV bannerUV = this.setup.uvs().banner();
        GUIs.drawGUITexture(graphics, this.setup.texture(), 0, 5, bannerUV.u(), bannerUV.v(), 162, 14, alpha * this.guiAlpha);
    }

    protected void drawBanner(GuiGraphics graphics) {
        this.drawBanner(graphics, 1.0f);
    }

    protected void drawBackground(GuiGraphics graphics, float alpha) {
        GUIs.drawGUITexture(graphics, this.setup.texture(), 0, 20, 0, 0, 162, 40, alpha * this.guiAlpha);
        GUIs.drawGUITexture(graphics, this.setup.texture(), 144, 56, 0, 108, 9, 14, alpha * this.guiAlpha);
    }

    protected void drawBackground(GuiGraphics graphics) {
        this.drawBackground(graphics, 1.0f);
    }
}

