/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.ui;

import java.util.ArrayList;
import java.util.List;
import net.bivrik.fancytoasts.client.ui.CreditsManager;
import net.bivrik.fancytoasts.platform.utility.Components;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import org.jetbrains.annotations.NotNull;

public class CreditsList
extends AbstractSelectionList<Entry> {
    private final List<CreditsListEntry> lines = new ArrayList<CreditsListEntry>(10);
    private float autoScrollSpeed = 0.4f;

    public CreditsList(Minecraft minecraft, int width, int height, int x, int y, CreditsManager.CreditsData data) {
        super(minecraft, width, height, y, 18);
        this.setX(x);
        this.updateList(data);
    }

    private void updateList(CreditsManager.CreditsData data) {
        for (int i = 0; i < this.height / this.itemHeight + 2; ++i) {
            this.addSpace();
        }
        for (String category : data.categories().keySet()) {
            this.addCategory(category);
            for (CreditsManager.CreditsData.User user : data.categories().get(category)) {
                this.addLine(user);
            }
            this.addSpace();
        }
        for (int i = 0; i < this.height / this.itemHeight; ++i) {
            this.addSpace();
        }
        this.acceptLines();
    }

    private void acceptLines() {
        for (CreditsListEntry line : this.lines) {
            this.addEntry(line);
        }
    }

    private void addSpace() {
        this.lines.add(new CreditsListEntry(this, "", null, false));
    }

    private void addCategory(String category) {
        this.lines.add(new CreditsListEntry(this, category, null, true));
    }

    private void addLine(CreditsManager.CreditsData.User user) {
        this.lines.add(new CreditsListEntry(this, user.name(), user.annotation(), false));
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        return false;
    }

    public void scroll() {
        this.setScrollAmount(this.getScrollAmount() + (double)this.autoScrollSpeed);
        if (this.getScrollAmount() == (double)this.getMaxScroll()) {
            this.setScrollAmount(0.0);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 32) {
            this.autoScrollSpeed = 1.2f;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 32) {
            this.autoScrollSpeed = 0.4f;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    protected void renderListBackground(@NotNull GuiGraphics guiGraphics) {
    }

    protected void renderListSeparators(@NotNull GuiGraphics guiGraphics) {
    }

    protected boolean scrollbarVisible() {
        return false;
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput narrationElementOutput) {
    }

    private static class CreditsListEntry
    extends Entry {
        private final CreditsList list;
        private final String content;
        private final String annotation;
        private final Font font;
        private final int color;
        private final boolean isCategory;
        private final boolean isSpace;

        public CreditsListEntry(CreditsList list, String content, String annotation, boolean isCategory) {
            this.list = list;
            this.content = content.compareTo("{user.name}") == 0 ? this.list.minecraft.getUser().getName() : content;
            this.annotation = annotation;
            this.font = ((CreditsList)this.list).minecraft.font;
            this.color = !isCategory ? -1 : -256;
            this.isCategory = isCategory;
            this.isSpace = content.isEmpty();
        }

        public void render(@NotNull GuiGraphics guiGraphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean isHovering, float partialTick) {
            if (this.isSpace) {
                return;
            }
            if (this.isCategory) {
                guiGraphics.drawCenteredString(this.font, Components.of("gui.label." + this.content), this.list.getWidth() / 2, y, this.color);
            } else {
                guiGraphics.drawString(this.font, this.content, x, y, this.color);
                if (this.annotation != null && !this.annotation.isEmpty()) {
                    guiGraphics.drawString(this.font, this.annotation, x + this.font.width(this.content) + 8, y, -6250336);
                }
            }
        }
    }

    protected static abstract class Entry
    extends AbstractSelectionList.Entry<Entry> {
        protected Entry() {
        }
    }
}

