/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.ui;

import java.util.ArrayList;
import java.util.List;
import net.bivrik.fancytoasts.client.ui.CreditsManager;
import net.bivrik.fancytoasts.platform.utility.Components;
import net.minecraft.class_11908;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;

public class CreditsList
extends class_350<Entry> {
    private final List<CreditsListEntry> lines = new ArrayList<CreditsListEntry>(10);
    private float scrollSpeed = 0.4f;

    public CreditsList(class_310 minecraft, int width, int height, int x, int y, CreditsManager.CreditsData data) {
        super(minecraft, width, height, y, 18);
        this.method_46421(x);
        this.updateList(data);
    }

    private void updateList(CreditsManager.CreditsData data) {
        for (int i = 0; i < this.field_22759 / this.field_62109 + 2; ++i) {
            this.addSpace();
        }
        for (String category : data.categories().keySet()) {
            this.addCategory(category);
            for (CreditsManager.CreditsData.User user : data.categories().get(category)) {
                this.addLine(user);
            }
            this.addSpace();
        }
        for (int i = 0; i < this.field_22759 / this.field_62109; ++i) {
            this.addSpace();
        }
        this.acceptLines();
    }

    public void method_65506() {
    }

    private void acceptLines() {
        for (CreditsListEntry line : this.lines) {
            this.method_25321(line);
        }
    }

    private void addSpace() {
        this.lines.add(new CreditsListEntry(this, "", null, false));
    }

    private void addCategory(String category) {
        this.lines.add(new CreditsListEntry(this, category, null, true));
    }

    private void addLine(CreditsManager.CreditsData.User user) {
        this.lines.add(new CreditsListEntry(this, user.name(), user.annotation(), false));
    }

    public void scroll() {
        this.method_44382(this.method_44387() + (double)this.scrollSpeed);
        if (this.method_44387() == (double)this.method_44390()) {
            this.method_44382(0.0);
        }
    }

    public boolean method_25404(class_11908 event) {
        if (event.comp_4795() == 32) {
            this.scrollSpeed = 1.2f;
        }
        return super.method_25404(event);
    }

    public boolean method_16803(class_11908 event) {
        if (event.comp_4795() == 32) {
            this.scrollSpeed = 0.4f;
        }
        return super.method_16803(event);
    }

    protected void method_57715(@NotNull class_332 guiGraphics) {
    }

    protected void method_57713(@NotNull class_332 guiGraphics) {
    }

    protected boolean method_44392() {
        return false;
    }

    protected double method_44393() {
        return 0.0;
    }

    protected void method_47399(@NotNull class_6382 narrationElementOutput) {
    }

    private static class CreditsListEntry
    extends Entry {
        private final CreditsList list;
        private final String content;
        private final String annotation;
        private final class_327 font;
        private final int color;
        private final boolean isCategory;
        private final boolean isSpace;

        public CreditsListEntry(CreditsList list, String content, String annotation, boolean isCategory) {
            this.list = list;
            this.content = content.compareTo("{user.name}") == 0 ? this.list.field_22740.method_1548().method_1676() : content;
            this.annotation = annotation;
            this.font = ((CreditsList)this.list).field_22740.field_1772;
            this.color = !isCategory ? -1 : -256;
            this.isCategory = isCategory;
            this.isSpace = content.isEmpty();
        }

        public void method_25343(@NotNull class_332 guiGraphics, int mouseX, int mouseY, boolean isHovering, float partialTick) {
            if (this.isSpace) {
                return;
            }
            if (this.isCategory) {
                guiGraphics.method_27534(this.font, Components.of("gui.label." + this.content), this.list.method_25368() / 2, this.method_46427(), this.color);
            } else {
                guiGraphics.method_25303(this.font, this.content, this.method_46426(), this.method_46427(), this.color);
                if (this.annotation != null && !this.annotation.isEmpty()) {
                    guiGraphics.method_25303(this.font, this.annotation, this.method_46426() + this.font.method_1727(this.content) + 8, this.method_46427(), -6250336);
                }
            }
        }
    }

    protected static abstract class Entry
    extends class_350.class_351<Entry> {
        protected Entry() {
        }
    }
}

