/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.toast;

import java.util.Objects;
import net.bivrik.fancytoasts.Common;
import net.bivrik.fancytoasts.Debug;
import net.bivrik.fancytoasts.client.toast.ToastAnimationRegistry;
import net.bivrik.fancytoasts.client.toast.animation.FancyAdvancementSetup;
import net.bivrik.fancytoasts.client.toast.animation.FancyAdvancementToastAnimation;
import net.bivrik.fancytoasts.client.toast.texture.TextureUV;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_161;
import net.minecraft.class_185;
import net.minecraft.class_189;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;

public class FancyAdvancementToast {
    private static final int WIDTH = 162;
    private static final int HEIGHT = 70;
    private final FancyAdvancementToastAnimation animation;
    private final class_2960 toastSoundId;
    private final float volume;
    private class_1144 soundManager;
    private boolean isEnded = false;
    private long time;
    private int playedSoundsCount = 0;

    public FancyAdvancementToast(class_161 advancement, class_2960 texture, class_2960 animationId) {
        class_185 display = advancement.method_686();
        this.animation = ToastAnimationRegistry.getAnimation(animationId).get();
        switch (Objects.requireNonNull(display).method_815()) {
            case field_1254: {
                this.animation.setup(new FancyAdvancementSetup(texture, TextureUV.TASK_FRAME_UV, display, -256, -1), this);
                this.toastSoundId = Common.getConfigManager().getToastConfig().getSoundId(class_189.field_1254);
                this.volume = Common.getConfigManager().getGeneralConfig().getTaskVolume();
                break;
            }
            case field_1249: {
                this.animation.setup(new FancyAdvancementSetup(texture, TextureUV.GOAL_FRAME_UV, display, -14483457, -1), this);
                this.toastSoundId = Common.getConfigManager().getToastConfig().getSoundId(class_189.field_1249);
                this.volume = Common.getConfigManager().getGeneralConfig().getGoalVolume();
                break;
            }
            case field_1250: {
                this.animation.setup(new FancyAdvancementSetup(texture, TextureUV.CHALLENGE_FRAME_UV, display, -377606, -14483457), this);
                this.toastSoundId = Common.getConfigManager().getToastConfig().getSoundId(class_189.field_1250);
                this.volume = Common.getConfigManager().getGeneralConfig().getChallengeVolume();
                break;
            }
            default: {
                throw new RuntimeException("Could match correct advancement type");
            }
        }
        Debug.info("Created new Fancy Advancement Toast: {}", display.method_811().getString());
    }

    public void draw(class_332 graphics, class_310 minecraft) {
        this.animation.draw(graphics, minecraft, this.time);
    }

    public void update(long time) {
        this.time = time;
        if (this.time >= (long)this.animation.getDuration()) {
            this.isEnded = true;
        }
        if (this.soundManager != null) {
            int timeInSeconds = (int)(this.time / 50L);
            if (this.playedSoundsCount == 0 && timeInSeconds == this.animation.getToastSoundTiming() / 50) {
                class_3414 tse = class_3414.method_47909((class_2960)this.toastSoundId, (float)0.0f);
                this.soundManager.method_4873((class_1113)class_1109.method_4757((class_3414)tse, (float)1.0f, (float)this.volume));
                ++this.playedSoundsCount;
            }
            if (this.playedSoundsCount == 1 && timeInSeconds == this.animation.getDuration() / 50 - 10) {
                this.soundManager.method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_14561, (float)1.0f, (float)1.5f));
                ++this.playedSoundsCount;
            }
        }
    }

    public void trySetSoundManager(class_1144 soundManager) {
        if (!Common.getConfigManager().getGeneralConfig().areSoundsEnabled()) {
            return;
        }
        this.soundManager = soundManager;
        this.soundManager.method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_14561, (float)1.0f, (float)1.5f));
    }

    public class_310 getMinecraft() {
        return class_310.method_1551();
    }

    public boolean isEnded() {
        return this.isEnded;
    }

    public int getWidth() {
        return 162;
    }

    public int getHeight() {
        return 70;
    }
}

