/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.ui;

import java.util.ArrayList;
import java.util.List;
import net.bivrik.fancytoasts.client.ui.CreditsManager;
import net.bivrik.fancytoasts.platform.utility.Components;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;

public class CreditsList
extends class_350<Entry> {
    private final List<CreditsListEntry> lines = new ArrayList<CreditsListEntry>(10);
    private float autoScrollSpeed = 0.4f;

    public CreditsList(class_310 minecraft, int width, int height, int x, int y, CreditsManager.CreditsData data) {
        super(minecraft, width, height, y, y + height, 18);
        this.field_19088 = x;
        this.field_19087 = x + width;
        this.method_29344(false);
        this.method_31323(false);
        this.updateList(data);
    }

    private void updateList(CreditsManager.CreditsData data) {
        for (int i = 0; i < this.field_22743 / this.field_22741 + 2; ++i) {
            this.addSpace();
        }
        for (String category : data.categories().keySet()) {
            this.addCategory(category);
            for (CreditsManager.CreditsData.User user : data.categories().get(category)) {
                this.addLine(user);
            }
            this.addSpace();
        }
        for (int i = 0; i < this.field_22743 / this.field_22741; ++i) {
            this.addSpace();
        }
        this.acceptLines();
    }

    private void acceptLines() {
        for (CreditsListEntry line : this.lines) {
            this.method_25321(line);
        }
    }

    protected int method_25329() {
        return this.field_22742 * 2;
    }

    private void addSpace() {
        this.lines.add(new CreditsListEntry(this, "", null, false));
    }

    private void addCategory(String category) {
        this.lines.add(new CreditsListEntry(this, category, null, true));
    }

    private void addLine(CreditsManager.CreditsData.User user) {
        this.lines.add(new CreditsListEntry(this, user.name(), user.annotation(), false));
    }

    public void scroll() {
        this.method_25307(this.method_25341() + (double)this.autoScrollSpeed);
        if (this.method_25341() == (double)this.method_25331()) {
            this.method_25307(0.0);
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 32) {
            this.autoScrollSpeed = 1.2f;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 32) {
            this.autoScrollSpeed = 0.4f;
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        return false;
    }

    public void method_37020(class_6382 narrationElementOutput) {
    }

    private static class CreditsListEntry
    extends Entry {
        private final CreditsList list;
        private final String content;
        private final String annotation;
        private final class_327 font;
        private final int color;
        private final boolean isCategory;
        private final boolean isSpace;

        public CreditsListEntry(CreditsList list, String content, String annotation, boolean isCategory) {
            this.list = list;
            this.content = content.compareTo("{user.name}") == 0 ? this.list.field_22740.method_1548().method_1676() : content;
            this.annotation = annotation;
            this.font = ((CreditsList)this.list).field_22740.field_1772;
            this.color = !isCategory ? -1 : -256;
            this.isCategory = isCategory;
            this.isSpace = content.isEmpty();
        }

        public void method_25343(@NotNull class_332 guiGraphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean isHovering, float partialTick) {
            if (this.isSpace) {
                return;
            }
            if (this.isCategory) {
                guiGraphics.method_27534(this.font, Components.of("gui.label." + this.content), this.list.field_22742 / 2, y, this.color);
            } else {
                guiGraphics.method_25303(this.font, this.content, x, y, this.color);
                if (this.annotation != null && !this.annotation.isEmpty()) {
                    guiGraphics.method_25303(this.font, this.annotation, x + this.font.method_1727(this.content) + 8, y, -6250336);
                }
            }
        }
    }

    protected static abstract class Entry
    extends class_350.class_351<Entry> {
        protected Entry() {
        }
    }
}

