/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.ui;

import net.bivrik.fancytoasts.client.gui.ToastConfigScreen;
import net.bivrik.fancytoasts.client.toast.ToastAnimationRegistry;
import net.bivrik.fancytoasts.client.toast.ToastTextureRegistry;
import net.bivrik.fancytoasts.client.toast.texture.DisplayData;
import net.bivrik.fancytoasts.platform.utility.Components;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7923;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SettingType {
    TEXTURES("textures"){

        @Override
        public void apply(ToastConfigScreen instance, class_2960 id) {
            instance.getConfigData().setTextureId(id);
        }

        @Override
        public DisplayData getDisplayData(class_2960 id) {
            return ToastTextureRegistry.getData(id);
        }

        @Override
        public class_2960 getCurrentId(ToastConfigScreen instance) {
            return instance.getConfigData().getTextureId();
        }

        @Override
        public class_2960[] getKeySet() {
            return ToastTextureRegistry.getIds().toArray(new class_2960[0]);
        }
    }
    ,
    ANIMATIONS("animations"){

        @Override
        public void apply(ToastConfigScreen instance, class_2960 id) {
            instance.getConfigData().setAnimationId(id);
        }

        @Override
        public DisplayData getDisplayData(class_2960 id) {
            return ToastAnimationRegistry.getData(id);
        }

        @Override
        public class_2960 getCurrentId(ToastConfigScreen instance) {
            return instance.getConfigData().getAnimationId();
        }

        @Override
        public class_2960[] getKeySet() {
            return ToastAnimationRegistry.getIds().toArray(new class_2960[0]);
        }
    }
    ,
    SOUNDS("sounds"){

        @Override
        public void apply(ToastConfigScreen instance, class_2960 id) {
            instance.getConfigData().putSound(instance.getAdvancementType(), id);
        }

        @Override
        public DisplayData getDisplayData(class_2960 id) {
            DisplayData data = id.method_42094().contains("minecraft") ? new DisplayData((class_2561)class_2561.method_43470((String)id.method_42094()), "Minecraft", Components.of("sound.minecraft.description")) : (class_7923.field_41172.method_10250(id) ? new DisplayData((class_2561)class_2561.method_43470((String)id.method_42094()), this.getAuthor(id.method_12836()), Components.of("sound.mod.description")) : new DisplayData((class_2561)class_2561.method_43470((String)id.method_42094()), this.getAuthor(id.method_12836()), Components.of("sound.resource_pack.description")));
            return data;
        }

        private String getAuthor(String namespace) {
            String end = namespace.substring(1);
            String start = namespace.substring(0, 1).toUpperCase();
            return start + end;
        }

        @Override
        public class_2960 getCurrentId(ToastConfigScreen instance) {
            return instance.getConfigData().getSoundId(instance.getAdvancementType());
        }

        @Override
        public class_2960[] getKeySet() {
            return class_310.method_1551().method_1483().method_4864().toArray(new class_2960[0]);
        }
    };

    private final String name;

    public abstract void apply(ToastConfigScreen var1, class_2960 var2);

    public abstract DisplayData getDisplayData(class_2960 var1);

    public abstract class_2960 getCurrentId(ToastConfigScreen var1);

    public abstract class_2960[] getKeySet();

    private SettingType(String name) {
        this.name = name;
    }

    public class_2561 getDisplayName() {
        return class_2561.method_43471((String)("fancytoasts.gui.label." + this.name));
    }

    public String getName() {
        return this.name;
    }
}

