/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.toast;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayDeque;
import java.util.Deque;
import net.bivrik.fancytoasts.Common;
import net.bivrik.fancytoasts.client.config.AdvancementToastScreenBehavior;
import net.bivrik.fancytoasts.client.config.ToastConfigData;
import net.bivrik.fancytoasts.client.toast.FancyAdvancementToast;
import net.bivrik.fancytoasts.platform.Services;
import net.bivrik.fancytoasts.platform.utility.GUIs;
import net.minecraft.Util;
import net.minecraft.advancements.Advancement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;

public class AdvancementToastManager {
    private static final Deque<FancyAdvancementToast> ADVANCEMENT_TOASTS = new ArrayDeque<FancyAdvancementToast>();
    private final Minecraft minecraft;
    private FancyAdvancementToast current;
    private long startTime;

    public AdvancementToastManager(Minecraft minecraft) {
        this.minecraft = minecraft;
    }

    public void addAdvancement(Advancement advancement) {
        ToastConfigData toastConfig = Common.getConfigManager().getToastConfig();
        FancyAdvancementToast fancyAdvancement = new FancyAdvancementToast(advancement, toastConfig.getTextureId(), toastConfig.getAnimationId());
        ADVANCEMENT_TOASTS.add(fancyAdvancement);
        if (Common.getConfigManager().getGeneralConfig().isJadeCompatEnabled()) {
            Services.PLATFORM.tryDisableJade();
        }
    }

    public void update() {
        if (this.current != null) {
            long time = Util.getMillis() - this.startTime;
            this.current.update(time);
            if (this.current.isEnded()) {
                this.current = null;
                if (!Services.PLATFORM.isJadeEnabled() && Common.getConfigManager().getGeneralConfig().isJadeCompatEnabled()) {
                    Services.PLATFORM.tryEnableJade();
                }
            }
            return;
        }
        if (!ADVANCEMENT_TOASTS.isEmpty()) {
            this.current = ADVANCEMENT_TOASTS.getFirst();
            this.current.trySetSoundManager(this.minecraft.getSoundManager());
            ADVANCEMENT_TOASTS.removeFirst();
            this.startTime = Util.getMillis();
        }
    }

    public boolean isScreenOpened() {
        return this.minecraft.screen != null && !(this.minecraft.screen instanceof ChatScreen);
    }

    public boolean isRenderUnder() {
        return Common.getConfigManager().getGeneralConfig().getScreenBehavior() == AdvancementToastScreenBehavior.BEHIND;
    }

    public void render(GuiGraphics graphics) {
        if (this.current == null || this.minecraft.options.hideGui) {
            return;
        }
        int xPos = Common.getConfigManager().getGeneralConfig().getPosition().getX(this.current.getWidth(), graphics.guiWidth());
        PoseStack matrix = GUIs.getStack(graphics);
        GUIs.push(matrix);
        GUIs.translate(matrix, xPos, 20.0f, 800.0f);
        this.current.draw(graphics, this.minecraft);
        GUIs.pop(matrix);
    }

    public void clear() {
        ADVANCEMENT_TOASTS.clear();
        this.current = null;
        if (!Services.PLATFORM.isJadeEnabled() && Common.getConfigManager().getGeneralConfig().isJadeCompatEnabled()) {
            Services.PLATFORM.tryEnableJade();
        }
    }
}

