/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.toast;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.bivrik.fancytoasts.Debug;
import net.bivrik.fancytoasts.client.toast.texture.DisplayData;
import net.bivrik.fancytoasts.platform.utility.Components;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class ToastTextureRegistry {
    private static final Map<ResourceLocation, DisplayData> TEXTURES = new HashMap<ResourceLocation, DisplayData>();

    public static boolean register(ResourceLocation id, String modId, String name, String author, String description) {
        MutableComponent translatableDescription;
        MutableComponent componentName;
        if (TEXTURES.containsKey(id)) {
            Debug.error("{} already exists! It needs to be unique", id);
            return false;
        }
        if (modId != null) {
            componentName = Components.translatableTexture(modId, name);
            translatableDescription = Component.translatable((String)description);
        } else {
            componentName = Component.literal((String)name);
            translatableDescription = Component.literal((String)description);
        }
        DisplayData data = new DisplayData((Component)componentName, author, (Component)translatableDescription);
        TEXTURES.put(id, data);
        Debug.info("Registered {}", id);
        return true;
    }

    public static boolean register(ResourceLocation id, String modId, String name, String author) {
        return ToastTextureRegistry.register(id, modId, name, author, modId + ".textures.toast." + name + ".description");
    }

    public static void clearCustom() {
        ToastTextureRegistry.getIds().removeIf(id -> id.toString().contains("config"));
    }

    public static DisplayData getData(ResourceLocation id) {
        return TEXTURES.computeIfAbsent(id, key -> {
            Debug.error("Texture {} is missing", key);
            return new DisplayData((Component)Component.translatable((String)"fancytoasts.textures.toast.vanilla"), "Fancy Toasts", (Component)Component.translatable((String)"fancytoasts.textures.vanilla.description"));
        });
    }

    public static boolean isRegistered(ResourceLocation id) {
        return TEXTURES.getOrDefault(id, null) != null;
    }

    public static Component getTextureName(ResourceLocation id) {
        return ToastTextureRegistry.getData(id).getName();
    }

    public static Component getTextureAuthor(ResourceLocation id) {
        return ToastTextureRegistry.getData(id).getAuthor();
    }

    public static Collection<ResourceLocation> getIds() {
        return TEXTURES.keySet();
    }
}

