/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.toast.animation;

import net.bivrik.fancytoasts.Common;
import net.bivrik.fancytoasts.client.config.AdvancementToastScreenBehavior;
import net.bivrik.fancytoasts.client.toast.FancyAdvancementToast;
import net.bivrik.fancytoasts.client.toast.animation.FancyAdvancementSetup;
import net.bivrik.fancytoasts.client.toast.texture.TextureUV;
import net.bivrik.fancytoasts.platform.utility.GUIs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

public abstract class FancyAdvancementToastAnimation {
    protected FancyAdvancementSetup setup;
    protected FancyAdvancementToast toast;
    private float alpha = 1.0f;

    public void setup(FancyAdvancementSetup setup, FancyAdvancementToast toast) {
        this.setup = setup;
        this.toast = toast;
    }

    public void draw(GuiGraphics guiGraphics, Minecraft minecraft, long time) {
        this.alpha = Common.getAdvancementToastManager().isScreenOpened() && Common.getConfigManager().getGeneralConfig().getScreenBehavior() == AdvancementToastScreenBehavior.TRANSPARENT ? 0.5f : 1.0f;
    }

    public abstract int getDuration();

    public abstract int getToastSoundTiming();

    protected void drawIcon(GuiGraphics graphics) {
        TextureUV frameUV = this.setup.uvs().frame();
        GUIs.drawTransparentGUITexture(graphics, this.setup.texture(), 68, 0, frameUV.u(), frameUV.v(), 26, 26, this.alpha);
        graphics.renderFakeItem(this.setup.display().getIcon(), 73, 5);
    }

    protected void drawBanner(GuiGraphics graphics) {
        TextureUV bannerUV = this.setup.uvs().banner();
        GUIs.drawTransparentGUITexture(graphics, this.setup.texture(), 0, 5, bannerUV.u(), bannerUV.v(), 162, 14, this.alpha);
    }

    protected void drawBackground(GuiGraphics graphics) {
        GUIs.drawTransparentGUITexture(graphics, this.setup.texture(), 0, 20, 0, 0, 162, 40, this.alpha);
        GUIs.drawTransparentGUITexture(graphics, this.setup.texture(), 144, 56, 0, 108, 9, 14, this.alpha);
    }
}

