/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts;

import java.util.function.Supplier;
import net.bivrik.fancytoasts.ConfigManager;
import net.bivrik.fancytoasts.Debug;
import net.bivrik.fancytoasts.client.KeyBindingManager;
import net.bivrik.fancytoasts.client.config.ConfigTextureManager;
import net.bivrik.fancytoasts.client.toast.AdvancementToastManager;
import net.bivrik.fancytoasts.client.toast.ToastAnimationRegistry;
import net.bivrik.fancytoasts.client.toast.ToastTextureRegistry;
import net.bivrik.fancytoasts.client.toast.animation.FancyAdvancementToastAnimation;
import net.bivrik.fancytoasts.client.toast.animation.OldlikeAnimation;
import net.bivrik.fancytoasts.client.toast.animation.PlayfulAnimation;
import net.bivrik.fancytoasts.client.toast.animation.QuirkyAnimation;
import net.bivrik.fancytoasts.client.toast.animation.StandardAnimation;
import net.bivrik.fancytoasts.client.ui.CreditsManager;
import net.bivrik.fancytoasts.client.ui.SplashManager;
import net.bivrik.fancytoasts.platform.Services;
import net.bivrik.fancytoasts.utility.DefaultLocations;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class Common {
    private static SplashManager splashManager;
    private static ConfigManager configManager;
    private static AdvancementToastManager advancementToastManager;
    private static KeyBindingManager keyBindingManager;
    private static CreditsManager creditsManager;

    public static SplashManager getSplashManager() {
        return splashManager;
    }

    public static ConfigManager getConfigManager() {
        return configManager;
    }

    public static AdvancementToastManager getAdvancementToastManager() {
        return advancementToastManager;
    }

    public static KeyBindingManager getKeyBindingManager() {
        return keyBindingManager == null ? (keyBindingManager = new KeyBindingManager()) : keyBindingManager;
    }

    public static CreditsManager getCreditsManager() {
        return creditsManager;
    }

    public static void onMinecraftInitialization(class_310 minecraft) {
        splashManager = new SplashManager(minecraft.method_1548());
        splashManager.load(minecraft.method_1478());
        configManager = new ConfigManager();
        configManager.loadConfigs();
        advancementToastManager = new AdvancementToastManager(minecraft);
        creditsManager = new CreditsManager();
        creditsManager.loadCredits();
    }

    public static void onModInitialization() {
        if (!Services.PLATFORM.isModLoaded("fancytoasts")) {
            return;
        }
        Debug.info("Common init on {} in a {} environment.", Services.PLATFORM.getPlatformName(), Services.PLATFORM.getEnvironmentName());
        Debug.info("Textures registration:");
        Common.registerTextures();
        Debug.info("Animations registration:");
        Common.registerAnimations();
    }

    public static void onTick() {
        keyBindingManager.tick();
    }

    private static void registerTextures() {
        Common.registerTexture(DefaultLocations.Textures.VANILLA, "vanilla");
        Common.registerTexture(DefaultLocations.Textures.NATURE, "nature");
        Common.registerTexture(DefaultLocations.Textures.OG, "og");
        Common.registerTexture(DefaultLocations.Textures.MODERN, "modern");
        Common.registerTexture(DefaultLocations.Textures.STEAMY, "steamy");
        Common.registerTexture(DefaultLocations.Textures.TERRACRAFT, "terracraft");
        ConfigTextureManager.load();
    }

    private static void registerAnimations() {
        Common.registerAnimation(DefaultLocations.Animations.STANDARD, "standard", StandardAnimation::new);
        Common.registerAnimation(DefaultLocations.Animations.PLAYFUL, "playful", PlayfulAnimation::new);
        Common.registerAnimation(DefaultLocations.Animations.QUIRKY, "quirky", QuirkyAnimation::new);
        Common.registerAnimation(DefaultLocations.Animations.OLDLIKE, "oldlike", OldlikeAnimation::new);
    }

    private static void registerTexture(class_2960 id, String name) {
        ToastTextureRegistry.register(id, "fancytoasts", name, "Fancy Toasts");
    }

    private static void registerAnimation(class_2960 id, String name, Supplier<FancyAdvancementToastAnimation> animation) {
        ToastAnimationRegistry.register(id, animation, "fancytoasts", name);
    }
}

