/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.config;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.bivrik.fancytoasts.Debug;
import net.bivrik.fancytoasts.client.config.JsonHelper;
import net.bivrik.fancytoasts.client.toast.ToastTextureRegistry;
import net.bivrik.fancytoasts.client.toast.texture.DisplayData;
import net.bivrik.fancytoasts.platform.utility.ResourceLocations;
import net.bivrik.fancytoasts.utility.file.FileHelper;
import net.bivrik.fancytoasts.utility.file.FileType;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class ConfigTextureManager {
    private static final Map<class_2960, Path> CONFIG_TEXTURES = new HashMap<class_2960, Path>();
    private static final File TEXTURES_DIR = new File("./config/fancytoasts/textures/");
    private static final FileFilter TEXTURE_FILES_FILTER = file -> {
        String name = file.getName();
        return name.endsWith(FileType.PNG.get()) || name.endsWith(FileType.JSON.get());
    };

    public static void registerInMinecraft(class_2960 id) {
        if (!ToastTextureRegistry.isRegistered(id)) {
            Debug.error("Could not register texture {} in minecraft texture manager", id);
            return;
        }
        try {
            class_1011 image = class_1011.method_49277((byte[])Files.readAllBytes(CONFIG_TEXTURES.get(id)));
            class_1043 dynamicTexture = new class_1043(image);
            class_310.method_1551().method_1531().method_4616(id, (class_1044)dynamicTexture);
            image.close();
            Debug.info("Registered texture {} in Minecraft", id);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void unregisterFromMinecraft(class_2960 id) {
        class_310.method_1551().method_1531().method_4615(id);
        Debug.info("Unregistered texture {} from Minecraft", id);
    }

    public static void releaseTexturesFromMinecraft() {
        for (class_2960 id : CONFIG_TEXTURES.keySet()) {
            ConfigTextureManager.unregisterFromMinecraft(id);
        }
    }

    public static void reload() {
        CONFIG_TEXTURES.clear();
        ToastTextureRegistry.clearCustom();
        ConfigTextureManager.load();
    }

    public static void load() {
        if (FileHelper.tryCreateDir(TEXTURES_DIR)) {
            return;
        }
        File[] files = TEXTURES_DIR.listFiles(TEXTURE_FILES_FILTER);
        if (files == null) {
            Debug.warn("There are no files in the config texture directory");
            return;
        }
        int initialCap = Math.max(0, files.length / 2 - 1);
        ArrayList<File> textureFiles = new ArrayList<File>(initialCap);
        ArrayList<File> jsonFiles = new ArrayList<File>(initialCap);
        for (File file : files) {
            String fileName = file.getName();
            if (fileName.endsWith(FileType.PNG.get())) {
                textureFiles.add(file);
                continue;
            }
            if (!fileName.endsWith(FileType.JSON.get())) continue;
            jsonFiles.add(file);
        }
        ConfigTextureManager.register(jsonFiles, textureFiles);
    }

    private static void register(List<File> jsonFiles, List<File> textureFiles) {
        for (File jsonFile : jsonFiles) {
            for (File textureFile : textureFiles) {
                if (FileHelper.getRawName(textureFile).compareTo(FileHelper.getRawName(jsonFile)) != 0) continue;
                Optional<DisplayData> optionalData = JsonHelper.tryToRead(jsonFile, DisplayData.class);
                if (optionalData.isPresent()) {
                    DisplayData data = optionalData.get();
                    class_2960 id = ResourceLocations.of(textureFile.getPath().replace("\\", "/").replaceFirst("./", ""));
                    if (!ToastTextureRegistry.register(id, null, data.getName().getString(), data.getAuthor().getString(), data.getDescription().getString())) continue;
                    CONFIG_TEXTURES.put(id, textureFile.toPath());
                    continue;
                }
                Debug.error("Texture data is outdated or corrupted! File: {}", jsonFile.getAbsolutePath());
            }
        }
    }
}

