/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.toast;

import java.util.ArrayDeque;
import java.util.Deque;
import net.bivrik.fancytoasts.Common;
import net.bivrik.fancytoasts.client.config.AdvancementToastScreenBehavior;
import net.bivrik.fancytoasts.client.config.ToastConfigData;
import net.bivrik.fancytoasts.client.toast.FancyAdvancementToast;
import net.bivrik.fancytoasts.platform.Services;
import net.bivrik.fancytoasts.platform.utility.GUIs;
import net.minecraft.class_156;
import net.minecraft.class_161;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_408;
import net.minecraft.class_4587;

public class AdvancementToastManager {
    private static final Deque<FancyAdvancementToast> ADVANCEMENT_TOASTS = new ArrayDeque<FancyAdvancementToast>();
    private final class_310 minecraft;
    private FancyAdvancementToast current;
    private long startTime;

    public AdvancementToastManager(class_310 minecraft) {
        this.minecraft = minecraft;
    }

    public void addAdvancement(class_161 advancement) {
        ToastConfigData toastConfig = Common.getConfigManager().getToastConfig();
        FancyAdvancementToast fancyAdvancement = new FancyAdvancementToast(advancement, toastConfig.getTextureId(), toastConfig.getAnimationId());
        ADVANCEMENT_TOASTS.add(fancyAdvancement);
        if (Common.getConfigManager().getGeneralConfig().isJadeCompatEnabled()) {
            Services.PLATFORM.tryDisableJade();
        }
    }

    public void update() {
        if (this.current != null) {
            long time = class_156.method_658() - this.startTime;
            this.current.update(time);
            if (this.current.isEnded()) {
                this.current = null;
                if (!Services.PLATFORM.isJadeEnabled() && Common.getConfigManager().getGeneralConfig().isJadeCompatEnabled() && ADVANCEMENT_TOASTS.isEmpty()) {
                    Services.PLATFORM.tryEnableJade();
                }
            }
            return;
        }
        if (!ADVANCEMENT_TOASTS.isEmpty()) {
            this.current = ADVANCEMENT_TOASTS.getFirst();
            this.current.trySetSoundManager(this.minecraft.method_1483());
            ADVANCEMENT_TOASTS.removeFirst();
            this.startTime = class_156.method_658();
        }
    }

    public boolean isScreenOpened() {
        return this.minecraft.field_1755 != null && !(this.minecraft.field_1755 instanceof class_408);
    }

    public boolean isRenderUnder() {
        return Common.getConfigManager().getGeneralConfig().getScreenBehavior() == AdvancementToastScreenBehavior.BEHIND;
    }

    public void render(class_332 graphics) {
        if (this.current == null || this.minecraft.field_1690.field_1842) {
            return;
        }
        int xPos = Common.getConfigManager().getGeneralConfig().getPosition().getX(this.current.getWidth(), graphics.method_51421());
        class_4587 matrix = GUIs.getStack(graphics);
        GUIs.push(matrix);
        GUIs.translate(matrix, xPos, 20.0f, 900.0f);
        this.current.draw(graphics, this.minecraft);
        GUIs.pop(matrix);
    }

    public void clear() {
        ADVANCEMENT_TOASTS.clear();
        this.current = null;
        if (!Services.PLATFORM.isJadeEnabled() && Common.getConfigManager().getGeneralConfig().isJadeCompatEnabled()) {
            Services.PLATFORM.tryEnableJade();
        }
    }
}

