/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.toast.animation;

import net.bivrik.fancytoasts.Common;
import net.bivrik.fancytoasts.client.config.AdvancementToastScreenBehavior;
import net.bivrik.fancytoasts.client.toast.FancyAdvancementToast;
import net.bivrik.fancytoasts.client.toast.animation.FancyAdvancementSetup;
import net.bivrik.fancytoasts.client.toast.texture.TextureUV;
import net.bivrik.fancytoasts.platform.utility.GUIs;
import net.minecraft.class_310;
import net.minecraft.class_332;

public abstract class FancyAdvancementToastAnimation {
    protected FancyAdvancementSetup setup;
    protected FancyAdvancementToast toast;
    private float guiAlpha;

    public void setup(FancyAdvancementSetup setup, FancyAdvancementToast toast) {
        this.setup = setup;
        this.toast = toast;
    }

    public void draw(class_332 guiGraphics, class_310 minecraft, long time) {
        this.guiAlpha = Common.getAdvancementToastManager().isScreenOpened() && Common.getConfigManager().getGeneralConfig().getScreenBehavior() == AdvancementToastScreenBehavior.TRANSPARENT ? 0.5f : 1.0f;
    }

    public abstract int getDuration();

    public abstract int getToastSoundTiming();

    protected void drawIcon(class_332 graphics, float alpha) {
        TextureUV frameUV = this.setup.uvs().frame();
        GUIs.drawGUITexture(graphics, this.setup.texture(), 68, 0, frameUV.u(), frameUV.v(), 26, 26, alpha * this.guiAlpha);
        graphics.method_51445(this.setup.display().method_821(), 73, 5);
    }

    protected void drawIcon(class_332 guiGraphics) {
        this.drawIcon(guiGraphics, 1.0f);
    }

    protected void drawBanner(class_332 graphics, float alpha) {
        TextureUV bannerUV = this.setup.uvs().banner();
        GUIs.drawGUITexture(graphics, this.setup.texture(), 0, 5, bannerUV.u(), bannerUV.v(), 162, 14, alpha * this.guiAlpha);
    }

    protected void drawBanner(class_332 graphics) {
        this.drawBanner(graphics, 1.0f);
    }

    protected void drawBackground(class_332 graphics, float alpha) {
        GUIs.drawGUITexture(graphics, this.setup.texture(), 0, 20, 0, 0, 162, 40, alpha * this.guiAlpha);
        GUIs.drawGUITexture(graphics, this.setup.texture(), 144, 56, 0, 108, 9, 14, alpha * this.guiAlpha);
    }

    protected void drawBackground(class_332 graphics) {
        this.drawBackground(graphics, 1.0f);
    }
}

