/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.ui;

import java.io.File;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bivrik.fancytoasts.Debug;
import net.bivrik.fancytoasts.client.config.JsonHelper;

public class CreditsManager {
    private static final String DROPBOX_CREDITS_URL = "https://dl.dropboxusercontent.com/scl/fi/0tupbdajo54oh29617kde/credits.json?rlkey=iro2kolfqyqg6h93gpws45h9s&st=is4wjcmi";
    private CreditsData credits;

    public CreditsData getCredits() {
        return this.credits;
    }

    public void loadCredits() {
        this.credits = this.readCredits();
        if (this.credits == null) {
            this.credits = this.getFallback();
        }
    }

    private CreditsData readCredits() {
        HttpResponse<String> httpResponse;
        HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
        HttpRequest httpRequest = HttpRequest.newBuilder(URI.create(DROPBOX_CREDITS_URL)).header("User-Agent", "FancyToasts").header("Cache-Control", "no-cache").build();
        try {
            httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
        }
        catch (Exception e) {
            Debug.error("Failed to access DropBox file: {}", e.getMessage());
            return null;
        }
        try {
            if (httpResponse.statusCode() == 200) {
                String response = httpResponse.body();
                if (response == null) {
                    Debug.warn("Response's body is empty, status: {}", httpResponse.statusCode());
                    return null;
                }
                return (CreditsData)JsonHelper.getGson().fromJson(response, CreditsData.class);
            }
            Debug.warn("Status: {}", httpResponse.statusCode());
            Debug.error("Failed to read response's body");
        }
        catch (Exception e) {
            Debug.error("Failed to get a response from DropBox: {}", e.getMessage());
        }
        Debug.warn("Failed to get credits");
        return null;
    }

    public CreditsData getFallback() {
        Debug.warn("Returning fallback for credits");
        CreditsData data = new CreditsData(new HashMap<String, List<CreditsData.User>>());
        data.addCategory("fallback", this.users(this.user("Credits couldn't be reached", ":("), this.user("Try restarting mod or just... don't look here yet"), this.user(":/")));
        return data;
    }

    public void createCredits() {
        CreditsData data = new CreditsData(new HashMap<String, List<CreditsData.User>>());
        data.addCategory("boosters", this.users(this.user("Halil Han", "First booster!")));
        data.addCategory("translators", this.users(this.user("Gao Xinyang", "Chinese (zh_cn)"), this.user("ChaTian", "Chinese (zh_tw"), this.user("PExPE3", "Japanese (ja_jp)")));
        data.addCategory("github_activists", this.users(this.user("VaporeonScripts", "<3"), this.user("Mysticpasta1"), this.user("PoIyframeX"), this.user("aisukuma"), this.user("ZakoFish"), this.user("pupcakie"), this.user("guguz"), this.user("TCK-MODDER"), this.user("Redls07"), this.user("HalilMan", "Important bug finder"), this.user("LiterallyLink"), this.user("teenecks"), this.user("F0rsakenPhant0M"), this.user("YnwLNE", "A truck with ideas"), this.user("Memory_Yzf")));
        data.addCategory("special_thanks", this.users(this.user("Dexpit"), this.user("Starfirexx"), this.user("{user.name}", "<3")));
        JsonHelper.tryToWrite(new File("./config/fancytoasts/dev_credits.json"), data);
    }

    private CreditsData.User user(String name, String annotation) {
        return new CreditsData.User(name, annotation);
    }

    private CreditsData.User user(String name) {
        return new CreditsData.User(name, null);
    }

    private List<CreditsData.User> users(CreditsData.User ... users) {
        return Arrays.asList(users);
    }

    public record CreditsData(Map<String, List<User>> categories) {
        public void addCategory(String category, List<User> users) {
            this.categories.put(category, users);
        }

        public record User(String name, String annotation) {
        }
    }
}

