/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.ui;

import java.util.ArrayList;
import java.util.List;
import net.bivrik.fancytoasts.Debug;
import net.bivrik.fancytoasts.client.toast.texture.DisplayData;
import net.bivrik.fancytoasts.platform.utility.GUIs;
import net.bivrik.fancytoasts.platform.utility.ResourceLocations;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;

public class InformationList
extends class_350<Entry> {
    private final List<InformationListEntry> lines = new ArrayList<InformationListEntry>(7);
    private class_2960 location;

    public InformationList(class_310 minecraft, int width, int height, int x, int y, DisplayData displayData, boolean isConfig) {
        super(minecraft, width, height, y, y + height, 10);
        this.field_19088 = x;
        this.field_19087 = x + width;
        this.method_29344(false);
        this.update(displayData, isConfig, true);
    }

    public void update(DisplayData displayData, boolean isConfig, boolean isAccepted) {
        if (displayData == null) {
            Debug.error("No Display Data to show in Information List");
            return;
        }
        this.location = isAccepted ? ResourceLocations.of("textures/icons/success.png") : ResourceLocations.of("textures/icons/looking.png");
        this.clear();
        this.addLine(displayData.getName(), -256);
        if (isConfig) {
            this.addLine((class_2561)class_2561.method_43471((String)"fancytoasts.gui.custom"), -2338993);
        }
        this.addSpace();
        this.addLine((class_2561)class_2561.method_43471((String)"fancytoasts.gui.label.author"), -1);
        this.addLine(displayData.getAuthor(), -6250336);
        this.addSpace();
        this.addLine((class_2561)class_2561.method_43471((String)"fancytoasts.gui.label.description"), -1);
        this.addLine(displayData.getDescription(), -6250336);
        this.acceptLines();
    }

    private void clear() {
        this.method_25339();
        this.method_25307(0.0);
        this.lines.clear();
    }

    private void addLine(class_2561 content, int color) {
        class_327 font = this.field_22740.field_1772;
        List textLines = font.method_1728((class_5348)content, this.method_25322());
        for (class_5481 textLine : textLines) {
            this.lines.add(new InformationListEntry(font, textLine, color));
        }
    }

    private void addSpace() {
        this.lines.add(new InformationListEntry(this.field_22740.field_1772, class_5481.field_26385, 0));
    }

    private void acceptLines() {
        for (InformationListEntry line : this.lines) {
            this.method_25321(line);
        }
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        GUIs.drawGUITexture(guiGraphics, this.location, this.field_19087 - 8 - 3, this.field_19085 + 3, 0, 0, 8, 8, 8, 8);
    }

    public int method_25322() {
        return this.field_22742 - 16 - 8;
    }

    public int method_25342() {
        return this.field_19088 + 8;
    }

    protected int method_25329() {
        return this.field_19087 - 8;
    }

    public void method_37020(class_6382 narrationElementOutput) {
    }

    private static final class InformationListEntry
    extends Entry {
        private final class_327 font;
        private final class_5481 content;
        private final int color;

        public InformationListEntry(class_327 font, class_5481 content, int color) {
            this.font = font;
            this.content = content;
            this.color = color;
        }

        public void method_25343(@NotNull class_332 guiGraphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean isHovering, float partialTick) {
            guiGraphics.method_35720(this.font, this.content, x, y + 3, this.color);
        }
    }

    protected static abstract class Entry
    extends class_350.class_351<Entry> {
        protected Entry() {
        }
    }
}

