/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.config;

import java.io.File;
import java.lang.runtime.SwitchBootstraps;
import java.util.EnumMap;
import java.util.Map;
import net.bivrik.fancytoasts.Debug;
import net.bivrik.fancytoasts.client.config.ConfigData;
import net.bivrik.fancytoasts.client.config.ConfigTextureManager;
import net.bivrik.fancytoasts.client.toast.ToastAnimationRegistry;
import net.bivrik.fancytoasts.client.toast.ToastTextureRegistry;
import net.bivrik.fancytoasts.utility.DefaultLocations;
import net.minecraft.class_1144;
import net.minecraft.class_189;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3417;

public class ToastConfigData
extends ConfigData {
    private class_2960 animationId;
    private class_2960 textureId;
    private final Map<class_189, class_2960> soundIds = new EnumMap<class_189, class_2960>(class_189.class);

    public ToastConfigData(class_2960 animationId, class_2960 textureId, Map<class_189, class_2960> soundIds) {
        super("./config/fancytoasts/toast.json");
        this.animationId = animationId;
        this.textureId = textureId;
        this.soundIds.putAll(soundIds);
    }

    public ToastConfigData() {
        super("./config/fancytoasts/toast.json");
        this.animationId = DefaultLocations.Animations.STANDARD;
        this.textureId = DefaultLocations.Textures.VANILLA;
        this.soundIds.putAll(Map.of(class_189.field_1254, class_3417.field_38365.method_14833(), class_189.field_1249, class_3417.field_14882.method_14833(), class_189.field_1250, class_3417.field_15195.method_14833()));
    }

    public class_2960 getAnimationId() {
        return this.animationId;
    }

    public void setAnimationId(class_2960 id) {
        this.animationId = id;
    }

    public class_2960 getTextureId() {
        return this.textureId;
    }

    public void setTextureId(class_2960 id) {
        this.textureId = id;
    }

    public class_2960 getSoundId(class_189 type) {
        class_1144 soundManager = class_310.method_1551().method_1483();
        if (!soundManager.method_4864().contains(this.soundIds.get(type))) {
            Debug.warn("Saved sounds are invalid. Used standard ones");
            class_189 class_1892 = type;
            int n = 0;
            switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"TASK", "GOAL"}, (class_189)class_1892, n)) {
                case 0: {
                    return class_3417.field_38365.method_14833();
                }
                case 1: {
                    return class_3417.field_14882.method_14833();
                }
            }
            return class_3417.field_15195.method_14833();
        }
        return this.soundIds.get(type);
    }

    public void putSound(class_189 type, class_2960 location) {
        this.soundIds.put(type, location);
    }

    @Override
    public String getPath() {
        File oldPathConfigFile = new File("./config/fancytoasts/standard.json");
        oldPathConfigFile.delete();
        return super.getPath();
    }

    @Override
    public boolean isValid() {
        if (ToastTextureRegistry.isRegistered(this.textureId)) {
            if (this.textureId.method_42094().contains("config")) {
                ConfigTextureManager.registerInMinecraft(this.textureId);
            }
        } else {
            return false;
        }
        return ToastAnimationRegistry.isRegistered(this.animationId);
    }

    @Override
    public ToastConfigData get() {
        return new ToastConfigData(this.animationId, this.textureId, this.soundIds);
    }

    @Override
    public String toString() {
        return super.toString().replace("}", ", ") + String.format("animationId='%s', textureId='%s', soundIds='%s'}", this.animationId, this.textureId, this.soundIds);
    }
}

