/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.toast.animation;

import java.util.ArrayList;
import java.util.List;
import net.bivrik.fancytoasts.client.toast.FancyAdvancementToast;
import net.bivrik.fancytoasts.client.toast.animation.Appearance;
import net.bivrik.fancytoasts.client.toast.animation.FancyAdvancementSetup;
import net.bivrik.fancytoasts.client.toast.animation.FancyAdvancementToastAnimation;
import net.bivrik.fancytoasts.platform.utility.Colors;
import net.bivrik.fancytoasts.platform.utility.GUIs;
import net.bivrik.fancytoasts.utility.MathEasing;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class OldlikeAnimation
extends FancyAdvancementToastAnimation {
    private static final Appearance ICON_APPEARANCE = new Appearance(2000, 0);
    private static final Appearance BANNER_APPEARANCE = new Appearance(2000, 100);
    private static final Appearance BACKGROUND_APPEARANCE = new Appearance(2000, 200);
    private static final Appearance TITLE_TEXT_APPEARANCE = new Appearance(2000, 1200);
    private static final Appearance TOAST_TEXT_APPEARANCE = new Appearance(2200, 1200);
    private static final int FADE_OUT_DURATION = 3000;
    private static final int DURATION = 6500;
    private List<class_5481> DESCRIPTION = new ArrayList<class_5481>();

    @Override
    public void setup(FancyAdvancementSetup setup, FancyAdvancementToast toast) {
        super.setup(setup, toast);
        this.DESCRIPTION = toast.getMinecraft().field_1772.method_1728((class_5348)setup.display().method_817(), this.toast.getWidth() - 16);
    }

    @Override
    public void draw(class_332 guiGraphics, class_310 minecraft, long time) {
        float alpha;
        super.draw(guiGraphics, minecraft, time);
        float iconAppearProgress = ICON_APPEARANCE.getProgress(time);
        float bannerAppearProgress = BANNER_APPEARANCE.getProgress(time);
        float backgroundAppearProgress = BACKGROUND_APPEARANCE.getProgress(time);
        float titleTextAppearProgress = TITLE_TEXT_APPEARANCE.getProgress(time);
        float toastTextAppearProgress = TOAST_TEXT_APPEARANCE.getProgress(time);
        float fadeOutProgress = Appearance.getProgress(time, 3000, 3500);
        class_4587 stack = GUIs.getStack(guiGraphics);
        if (bannerAppearProgress > 0.0f) {
            GUIs.push(stack);
            alpha = 1.0f;
            float x = 0.0f;
            if (bannerAppearProgress != 1.0f) {
                alpha = MathEasing.easeOutLerp(0.0f, 1.0f, bannerAppearProgress);
                x = MathEasing.easeOutLerp(35, 0, bannerAppearProgress);
            } else if (fadeOutProgress > 0.0f) {
                alpha = MathEasing.easeInLerp(1.0f, 0.0f, fadeOutProgress);
            }
            float y = (float)(5.0 - Math.sin((float)time / 700.0f) * 2.0);
            GUIs.translate(stack, x, y);
            this.drawBanner(guiGraphics, alpha);
            GUIs.pop(stack);
        }
        if (backgroundAppearProgress > 0.0f) {
            GUIs.push(stack);
            alpha = 1.0f;
            int x = 0;
            if (backgroundAppearProgress != 1.0f) {
                alpha = MathEasing.easeOutLerp(0.0f, 1.0f, backgroundAppearProgress);
                x = MathEasing.easeOutLerp(35, 0, backgroundAppearProgress);
            } else if (fadeOutProgress > 0.0f) {
                alpha = MathEasing.easeInLerp(1.0f, 0.0f, fadeOutProgress);
            }
            GUIs.translate(stack, x, 0.0f);
            this.drawBackground(guiGraphics, alpha);
            GUIs.pop(stack);
        }
        if (iconAppearProgress > 0.0f) {
            GUIs.push(stack);
            alpha = 1.0f;
            int x = 77;
            float scale = 1.0f;
            if (iconAppearProgress != 1.0f) {
                alpha = MathEasing.easeOutLerp(0.0f, 1.0f, iconAppearProgress);
                x = MathEasing.easeOutLerp(115, 77, iconAppearProgress);
            } else if (fadeOutProgress > 0.0f) {
                alpha = MathEasing.easeInLerp(1.0f, 0.0f, fadeOutProgress);
                scale = MathEasing.easeInLerp(1.0f, 0.0f, fadeOutProgress);
            }
            GUIs.translate(stack, x, 11.0f);
            GUIs.rotateAround(stack, (float)(Math.cos((double)time / 500.0) * (double)0.2f), 81.0f, 14.0f);
            GUIs.scaleAround(stack, scale, 81.0f, 14.0f);
            this.drawIcon(guiGraphics, alpha);
            GUIs.pop(stack);
        }
        class_327 font = minecraft.field_1772;
        int alphaTextFade = 0;
        if (fadeOutProgress > 0.0f) {
            alphaTextFade = MathEasing.easeInLerp(0, 244, fadeOutProgress);
        }
        if (titleTextAppearProgress > 0.05f) {
            int alpha2 = class_3532.method_15375((float)(titleTextAppearProgress * 255.0f)) - alphaTextFade;
            int titleColor = Colors.alpha(alpha2, this.setup.titleColor());
            int titleX = MathEasing.elasticEaseOutLerp(50, 0, titleTextAppearProgress);
            guiGraphics.method_27534(font, this.setup.display().method_815().method_30756(), this.toast.getWidth() / 2 + titleX, 25, titleColor);
        }
        if (toastTextAppearProgress > 0.05f) {
            int alpha3 = class_3532.method_15375((float)(toastTextAppearProgress * 255.0f)) - alphaTextFade;
            int toastColor = Colors.alpha(alpha3, this.setup.toastColor());
            int toastTitle = MathEasing.elasticEaseOutLerp(50, 0, toastTextAppearProgress);
            if (!this.DESCRIPTION.isEmpty()) {
                guiGraphics.method_35720(font, this.DESCRIPTION.get(0), 8 + toastTitle, 38, toastColor);
                if (this.DESCRIPTION.size() > 1) {
                    class_5481 descriptionSecondLine = this.DESCRIPTION.get(1);
                    guiGraphics.method_35720(font, descriptionSecondLine, 8 + toastTitle, 47, toastColor);
                    if (this.DESCRIPTION.size() > 2) {
                        guiGraphics.method_25303(font, "...", 8 + font.method_30880(descriptionSecondLine) + toastTitle, 47, toastColor);
                    }
                }
            }
        }
    }

    @Override
    public int getDuration() {
        return 6500;
    }

    @Override
    public int getToastSoundTiming() {
        return TITLE_TEXT_APPEARANCE.startPoint() + TITLE_TEXT_APPEARANCE.duration() / 5;
    }
}

