/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.toast.animation;

import java.util.ArrayList;
import java.util.List;
import net.bivrik.fancytoasts.client.toast.FancyAdvancementToast;
import net.bivrik.fancytoasts.client.toast.animation.Appearance;
import net.bivrik.fancytoasts.client.toast.animation.FancyAdvancementSetup;
import net.bivrik.fancytoasts.client.toast.animation.FancyAdvancementToastAnimation;
import net.bivrik.fancytoasts.platform.utility.Colors;
import net.bivrik.fancytoasts.platform.utility.GUIs;
import net.bivrik.fancytoasts.utility.MathEasing;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class PlayfulAnimation
extends FancyAdvancementToastAnimation {
    private static final Appearance ICON_APPEARANCE = new Appearance(1000, 0);
    private static final Appearance ICON_MOVEMENT = new Appearance(1500, 1000);
    private static final Appearance BANNER_APPEARANCE = new Appearance(1000, 1500);
    private static final Appearance BACKGROUND_APPEARANCE = new Appearance(800, 1600);
    private static final Appearance TEXT_APPEARANCE = new Appearance(1000, 2000);
    private static final int FADE_OUT_DURATION = 1500;
    private static final int DURATION = 7500;
    private List<class_5481> TITLE = new ArrayList<class_5481>();
    private List<class_5481> DESCRIPTION = new ArrayList<class_5481>();

    @Override
    public void setup(FancyAdvancementSetup setup, FancyAdvancementToast toast) {
        super.setup(setup, toast);
        this.TITLE = toast.getMinecraft().field_1772.method_1728((class_5348)setup.display().method_811(), this.toast.getWidth() - 16);
        this.DESCRIPTION = toast.getMinecraft().field_1772.method_1728((class_5348)setup.display().method_817(), this.toast.getWidth() - 16);
    }

    @Override
    public void draw(class_332 guiGraphics, class_310 minecraft, long time) {
        float rotation;
        float scale;
        super.draw(guiGraphics, minecraft, time);
        float iconAppearProgress = ICON_APPEARANCE.getProgress(time);
        float iconMovementProgress = ICON_MOVEMENT.getProgress(time);
        float bannerAppearProgress = BANNER_APPEARANCE.getProgress(time);
        float backgroundAppearProgress = BACKGROUND_APPEARANCE.getProgress(time);
        float textAppearProgress = TEXT_APPEARANCE.getProgress(time);
        float fadeOutProgress = Appearance.getProgress(time, 1500, 6000);
        class_4587 stack = GUIs.getStack(guiGraphics);
        float sinY = (float)Math.sin((double)time / 400.0) - 3.0f;
        if (fadeOutProgress > 0.0f) {
            float fadeOutScale = MathEasing.easeInLerp(1.0f, 0.0f, fadeOutProgress);
            float toastCenterX = (float)this.toast.getWidth() / 2.0f;
            float toastCenterY = (float)this.toast.getHeight() / 2.0f;
            GUIs.push(stack);
            GUIs.scaleAround(stack, fadeOutScale, toastCenterX, toastCenterY);
        }
        if (backgroundAppearProgress > 0.0f) {
            GUIs.push(stack);
            if (backgroundAppearProgress != 1.0f) {
                scale = MathEasing.elasticEaseOutLerp(0.0f, 1.0f, backgroundAppearProgress);
                rotation = MathEasing.elasticEaseOutLerp(-1.0f, 0.0f, backgroundAppearProgress);
                int y = MathEasing.easeOutLerp(-20, 0, backgroundAppearProgress);
                GUIs.scaleAround(stack, scale, 76.0f, 0.0f);
                GUIs.rotateAround(stack, rotation, 76.0f, 0.0f);
                GUIs.translate(stack, 0.0f, y);
            }
            this.drawBackground(guiGraphics);
            GUIs.pop(stack);
        }
        if (bannerAppearProgress > 0.0f) {
            GUIs.push(stack);
            if (bannerAppearProgress != 1.0f) {
                float scaleX = MathEasing.easeOutLerp(0.0f, 1.0f, bannerAppearProgress);
                GUIs.scaleAround(stack, scaleX, 1.0f, 15.0f, -12.0f);
            }
            GUIs.translate(stack, 0.0f, sinY);
            this.drawBanner(guiGraphics);
            GUIs.pop(stack);
        }
        if (iconAppearProgress > 0.0f) {
            GUIs.push(stack);
            if (iconAppearProgress != 1.0f) {
                scale = MathEasing.elasticEaseOutLerp(0.0f, 1.0f, iconAppearProgress);
                rotation = MathEasing.elasticEaseOutLerp(-1.0f, 0.0f, iconAppearProgress);
                GUIs.scaleAround(stack, scale, 81.0f, 13.0f);
                GUIs.rotateAround(stack, rotation, 81.0f, 13.0f);
            } else if (iconMovementProgress > 0.0f) {
                float x = MathEasing.easeOutLerp(0.0f, -60.0f, iconMovementProgress);
                GUIs.translate(stack, x, 0.0f);
            }
            GUIs.translate(stack, 0.0f, sinY - 5.0f);
            this.drawIcon(guiGraphics);
            GUIs.pop(stack);
        }
        if (textAppearProgress > 0.05f) {
            int a = class_3532.method_15375((float)(textAppearProgress * 255.0f));
            int titleColor = Colors.alpha(a, this.setup.titleColor());
            int toastColor = Colors.alpha(a, this.setup.toastColor());
            class_327 font = minecraft.field_1772;
            if (!this.TITLE.isEmpty()) {
                class_5481 titleLine = this.TITLE.get(0);
                if (this.TITLE.size() == 1) {
                    guiGraphics.method_35719(font, titleLine, this.toast.getWidth() / 2, 25, titleColor);
                } else {
                    guiGraphics.method_35719(font, titleLine, this.toast.getWidth() / 2 - font.method_1727("...") / 2, 25, titleColor);
                    guiGraphics.method_25300(font, "...", 1 + this.toast.getWidth() / 2 + font.method_30880(titleLine) / 2, 25, titleColor);
                }
            }
            if (!this.DESCRIPTION.isEmpty()) {
                guiGraphics.method_35720(font, this.DESCRIPTION.get(0), 8, 38, toastColor);
                if (this.DESCRIPTION.size() > 1) {
                    class_5481 descriptionSecondLine = this.DESCRIPTION.get(1);
                    guiGraphics.method_35720(font, descriptionSecondLine, 8, 47, toastColor);
                    if (this.DESCRIPTION.size() > 2) {
                        guiGraphics.method_25303(font, "...", 8 + font.method_30880(descriptionSecondLine), 47, toastColor);
                    }
                }
            }
        }
        if (fadeOutProgress > 0.0f) {
            GUIs.pop(stack);
        }
    }

    @Override
    public int getDuration() {
        return 7500;
    }

    @Override
    public int getToastSoundTiming() {
        return TEXT_APPEARANCE.startPoint();
    }
}

