/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.toast.animation;

import java.util.ArrayList;
import java.util.List;
import net.bivrik.fancytoasts.client.toast.FancyAdvancementToast;
import net.bivrik.fancytoasts.client.toast.animation.Appearance;
import net.bivrik.fancytoasts.client.toast.animation.FancyAdvancementSetup;
import net.bivrik.fancytoasts.client.toast.animation.FancyAdvancementToastAnimation;
import net.bivrik.fancytoasts.platform.utility.Colors;
import net.bivrik.fancytoasts.platform.utility.GUIs;
import net.bivrik.fancytoasts.utility.MathEasing;
import net.minecraft.class_185;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class StandardAnimation
extends FancyAdvancementToastAnimation {
    private static final Appearance ICON_APPEARANCE = new Appearance(2000, 0);
    private static final Appearance BANNER_APPEARANCE = new Appearance(500, 1500);
    private static final Appearance BACKGROUND_APPEARANCE = new Appearance(800, 1600);
    private static final Appearance TEXT_APPEARANCE = new Appearance(1000, 2000);
    private static final int FADE_OUT_DURATION = 2000;
    private static final int DURATION = 8000;
    private List<class_5481> DESCRIPTION = new ArrayList<class_5481>();

    @Override
    public void setup(FancyAdvancementSetup setup, FancyAdvancementToast toast) {
        super.setup(setup, toast);
        this.DESCRIPTION = toast.getMinecraft().field_1772.method_1728((class_5348)setup.display().method_811(), this.toast.getWidth() - 20);
    }

    @Override
    public void draw(class_332 guiGraphics, class_310 minecraft, long time) {
        super.draw(guiGraphics, minecraft, time);
        float iconAppearProgress = ICON_APPEARANCE.getProgress(time);
        float bannerAppearProgress = BANNER_APPEARANCE.getProgress(time);
        float backgroundAppearProgress = BACKGROUND_APPEARANCE.getProgress(time);
        float textAppearProgress = TEXT_APPEARANCE.getProgress(time);
        float fadeOutProgress = Appearance.getProgress(time, 2000, 6000);
        class_4587 stack = GUIs.getStack(guiGraphics);
        if (fadeOutProgress > 0.0f) {
            float fadeOutY = MathEasing.easeInLerp(0, -80, fadeOutProgress);
            GUIs.push(stack);
            GUIs.translate(stack, 0.0f, fadeOutY);
        }
        if (backgroundAppearProgress > 0.0f) {
            GUIs.push(stack);
            if (backgroundAppearProgress != 1.0f) {
                int y = MathEasing.easeOutLerp(-200, 0, backgroundAppearProgress);
                GUIs.translate(stack, 0.0f, y);
            }
            this.drawBackground(guiGraphics);
            GUIs.pop(stack);
        }
        if (bannerAppearProgress > 0.0f) {
            GUIs.push(stack);
            if (bannerAppearProgress != 1.0f) {
                float xScale = MathEasing.easeOutLerp(0.0f, 1.0f, bannerAppearProgress);
                GUIs.scaleAround(stack, xScale, 1.0f, 81.0f, 0.0f);
            }
            this.drawBanner(guiGraphics);
            GUIs.pop(stack);
        }
        if (iconAppearProgress > 0.0f) {
            GUIs.push(stack);
            if (iconAppearProgress != 1.0f) {
                int y = MathEasing.easeOutLerp(-100, 0, iconAppearProgress);
                float scale = MathEasing.easeOutLerp(0.0f, 1.0f, iconAppearProgress);
                GUIs.scaleAround(stack, scale, 81.0f, 13.0f);
                GUIs.translate(stack, 0.0f, y);
            }
            GUIs.translate(stack, 0.0f, (float)(Math.sin((float)time / 500.0f) * 1.5) - 5.0f);
            this.drawIcon(guiGraphics);
            GUIs.pop(stack);
        }
        if (textAppearProgress > 0.05f) {
            int a = class_3532.method_15375((float)(textAppearProgress * 255.0f));
            int titleColor = Colors.alpha(a, this.setup.titleColor());
            int toastColor = Colors.alpha(a, this.setup.toastColor());
            class_327 font = minecraft.field_1772;
            class_185 display = this.setup.display();
            guiGraphics.method_27534(font, display.method_815().method_30756(), this.toast.getWidth() / 2, 25, titleColor);
            if (!this.DESCRIPTION.isEmpty()) {
                if (this.DESCRIPTION.size() == 1) {
                    guiGraphics.method_35719(font, this.DESCRIPTION.get(0), this.toast.getWidth() / 2, 43, toastColor);
                } else {
                    int lineHeight = 42 - 9 * (this.DESCRIPTION.size() - 1) / 2;
                    for (class_5481 text : this.DESCRIPTION) {
                        guiGraphics.method_35719(font, text, this.toast.getWidth() / 2, lineHeight, toastColor);
                        lineHeight += 9;
                    }
                }
            }
        }
        if (fadeOutProgress > 0.0f) {
            GUIs.pop(stack);
        }
    }

    @Override
    public int getDuration() {
        return 8000;
    }

    @Override
    public int getToastSoundTiming() {
        return TEXT_APPEARANCE.startPoint();
    }
}

