/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts;

import java.util.HashMap;
import net.bivrik.fancytoasts.client.config.ConfigData;
import net.bivrik.fancytoasts.client.config.ConfigHandler;
import net.bivrik.fancytoasts.client.config.GeneralConfigData;
import net.bivrik.fancytoasts.client.config.ToastConfigData;

public class ConfigManager {
    private final HashMap<Class<? extends ConfigData>, ConfigData> CONFIGS = new HashMap();

    public void loadConfigs() {
        this.loadConfig(ToastConfigData.class);
        this.loadConfig(GeneralConfigData.class);
    }

    public <T extends ConfigData> void loadConfig(Class<T> configDataClass) {
        this.CONFIGS.remove(configDataClass);
        this.CONFIGS.put((Class<? extends ConfigData>)configDataClass, (ConfigData)ConfigHandler.load(configDataClass));
    }

    public <T extends ConfigData> void updateConfig(T configData) {
        this.CONFIGS.remove(configData.getClass());
        this.CONFIGS.put(configData.getClass(), configData);
    }

    public GeneralConfigData getGeneralConfig() {
        return (GeneralConfigData)this.CONFIGS.get(GeneralConfigData.class).get();
    }

    public ToastConfigData getToastConfig() {
        return (ToastConfigData)this.CONFIGS.get(ToastConfigData.class).get();
    }
}

