/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.bivrik.fancytoasts.Common;
import net.bivrik.fancytoasts.client.config.AdvancementToastPosition;
import net.bivrik.fancytoasts.client.config.AdvancementToastScreenBehavior;
import net.bivrik.fancytoasts.client.config.ConfigHandler;
import net.bivrik.fancytoasts.client.config.GeneralConfigData;
import net.bivrik.fancytoasts.client.gui.UniversalScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class GeneralConfigScreen
extends UniversalScreen {
    private final GeneralConfigData generalConfigData;
    private Button doneButton;
    private Button backButton;
    private CycleButton<Boolean> jadeCompatCycleButton;
    private CycleButton<Boolean> soundsEnabledCycleButton;
    private VolumeSlider taskVolumeSlider;
    private VolumeSlider goalVolumeSlider;
    private VolumeSlider challengeVolumeSlider;
    private CycleButton<AdvancementToastPosition> positionCycButton;
    private CycleButton<AdvancementToastScreenBehavior> screenBehaviorCycButton;
    private final List<AbstractWidget> widgets = new ArrayList<AbstractWidget>();

    public GeneralConfigScreen(Component title, Screen parent) {
        super(title, parent);
        this.generalConfigData = Common.getConfigManager().getGeneralConfig();
    }

    private void addWidget(AbstractWidget aw) {
        this.widgets.add(aw);
    }

    protected void init() {
        this.doneButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.done()).bounds(this.width / 2 + 100 - 125 + 4, this.height - 26, 150, 20).build());
        this.backButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_BACK, button -> this.toParentScreen()).bounds(this.width / 2 - 125 - 4, this.height - 20 - 6, 100, 20).build());
        this.jadeCompatCycleButton = CycleButton.onOffBuilder().withInitialValue((Object)this.generalConfigData.isJadeCompatEnabled()).withTooltip(value -> Tooltip.create((Component)Component.translatable((String)"fancytoasts.gui.tooltip.jade_compatibility"))).create(0, 0, 150, 20, (Component)Component.translatable((String)"fancytoasts.gui.label.jade_compatibility"), (button, value) -> this.generalConfigData.setJadeCompatEnabled((boolean)value));
        this.soundsEnabledCycleButton = CycleButton.onOffBuilder().withInitialValue((Object)this.generalConfigData.areSoundsEnabled()).withTooltip(value -> Tooltip.create((Component)Component.translatable((String)"fancytoasts.gui.tooltip.sounds_enabled"))).create(0, 0, 150, 20, (Component)Component.translatable((String)"fancytoasts.gui.label.sounds_enabled"), (button, value) -> this.generalConfigData.setSoundsEnabled((boolean)value));
        this.positionCycButton = CycleButton.builder(AdvancementToastPosition::getDisplayName).withValues((Object[])AdvancementToastPosition.values()).withInitialValue((Object)this.generalConfigData.getPosition()).withTooltip(position -> Tooltip.create((Component)Component.translatable((String)"fancytoasts.gui.tooltip.position"))).create(0, 0, 150, 20, (Component)Component.translatable((String)"fancytoasts.gui.label.position"), (button, value) -> this.generalConfigData.setPosition((AdvancementToastPosition)((Object)value)));
        this.screenBehaviorCycButton = CycleButton.builder(AdvancementToastScreenBehavior::getDisplayName).withValues((Object[])AdvancementToastScreenBehavior.values()).withInitialValue((Object)this.generalConfigData.getScreenBehavior()).withTooltip(position -> Tooltip.create((Component)Component.translatable((String)"fancytoasts.gui.tooltip.screen_behavior"))).create(0, 0, 150, 20, (Component)Component.translatable((String)"fancytoasts.gui.label.screen_behavior"), (button, value) -> this.generalConfigData.setScreenBehavior((AdvancementToastScreenBehavior)((Object)value)));
        this.taskVolumeSlider = new VolumeSlider(0, 0, 150, 20, (Component)Component.translatable((String)"fancytoasts.gui.label.task_volume"), this.generalConfigData.getTaskVolume());
        this.taskVolumeSlider.setResponder(this.generalConfigData::setTaskVolume);
        this.goalVolumeSlider = new VolumeSlider(0, 0, 150, 20, (Component)Component.translatable((String)"fancytoasts.gui.label.goal_volume"), this.generalConfigData.getGoalVolume());
        this.goalVolumeSlider.setResponder(this.generalConfigData::setGoalVolume);
        this.challengeVolumeSlider = new VolumeSlider(0, 0, 150, 20, (Component)Component.translatable((String)"fancytoasts.gui.label.challenge_volume"), this.generalConfigData.getChallengeVolume());
        this.challengeVolumeSlider.setResponder(this.generalConfigData::setChallengeVolume);
        this.addWidget((AbstractWidget)this.jadeCompatCycleButton);
        this.addWidget((AbstractWidget)this.soundsEnabledCycleButton);
        this.addWidget((AbstractWidget)this.positionCycButton);
        this.addWidget((AbstractWidget)this.screenBehaviorCycButton);
        this.addWidget((AbstractWidget)this.taskVolumeSlider);
        this.addWidget((AbstractWidget)this.goalVolumeSlider);
        this.addWidget((AbstractWidget)this.challengeVolumeSlider);
        int y = 40;
        for (int i = 0; i < this.widgets.size(); ++i) {
            int x = this.width / 2 - 150 - 4;
            if ((i & 1) == 0) {
                if (i != 0) {
                    y += 28;
                }
            } else {
                x += 158;
            }
            AbstractWidget widget = this.widgets.get(i);
            widget.setX(x);
            widget.setY(y);
            this.addRenderableWidget((GuiEventListener)widget);
        }
    }

    protected void rebuildWidgets() {
        this.widgets.clear();
        super.rebuildWidgets();
    }

    private void done() {
        ConfigHandler.save(this.generalConfigData);
        this.toParentScreen();
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        ResourceLocation resourcelocation = ResourceLocation.withDefaultNamespace((String)"textures/gui/menu_list_background.png");
        graphics.blit(RenderPipelines.GUI_TEXTURED, resourcelocation, 0, 32, 0.0f, 0.0f, this.width, this.height - 64 - 2, 32, 32);
        graphics.blit(RenderPipelines.GUI_TEXTURED, Screen.HEADER_SEPARATOR, 0, 32, 0.0f, 0.0f, this.width, 2, 32, 2);
        graphics.blit(RenderPipelines.GUI_TEXTURED, Screen.FOOTER_SEPARATOR, 0, this.height - 32 - 2, 0.0f, 0.0f, this.width, 2, 32, 2);
        super.render(graphics, mouseX, mouseY, partialTick);
    }

    private static class VolumeSlider
    extends AbstractSliderButton {
        private Consumer<Float> responder;
        private Component message;

        public VolumeSlider(int x, int y, int width, int height, Component message, double value) {
            super(x, y, width, height, (Component)Component.empty(), value / 2.0);
            this.message = message;
            this.updateMessage();
        }

        public void setResponder(Consumer<Float> responder) {
            this.responder = responder;
        }

        protected void updateMessage() {
            this.setMessage((Component)CommonComponents.optionNameValue((Component)this.message, (Component)Component.literal((String)(Math.round(this.getVolume() * 100.0f) + "%"))));
        }

        private float getVolume() {
            return (float)Math.round(Mth.lerp((double)this.value, (double)0.0, (double)2.0) * 100.0) / 100.0f;
        }

        protected void applyValue() {
            this.responder.accept(Float.valueOf(this.getVolume()));
        }
    }
}

