package com.bleudev.nine_lifes.mixin;

import com.bleudev.nine_lifes.custom.CustomEffects;
import com.bleudev.nine_lifes.interfaces.mixin.LivingEntityCustomInterface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3218;
import net.minecraft.class_6880;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin implements LivingEntityCustomInterface {
    @Shadow
    public abstract boolean hasStatusEffect(class_6880<class_1291> effect);

    @Unique
    private class_2338 lastLightPos;

    @Unique
    private int damage_ticks = -1;

    @Unique
    public void nine_lifes$setDamageTicks(int new_damage_ticks) {
        damage_ticks = new_damage_ticks;
    }

    @Unique
    public int nine_lifes$getDamageTicks() {
        return damage_ticks;
    }

    @Inject(method = "readCustomData", at = @At("RETURN"))
    private void readDamageTicks(class_11368 view, CallbackInfo ci) {
        damage_ticks = view.method_71424("damage_ticks", -1);
    }

    @Inject(method = "writeCustomData", at = @At("RETURN"))
    private void writeDamageTicks(class_11372 view, CallbackInfo ci) {
        view.method_71465("damage_ticks", damage_ticks);
    }

    @Inject(method = "tick", at = @At("RETURN"))
    public void tick(CallbackInfo ci) {
        class_1309 entity = (class_1309) (Object) this;

        if (entity.method_37908().field_9236) return;

        class_3218 serverWorld = (class_3218) entity.method_37908();
        boolean shouldLight = shouldEmitLight();
        int lightLevel = shouldLight ? 15 : 0;
        class_2338 footPos = entity.method_24515();

        List<class_2338> poses = List.of(footPos, footPos.method_10069(0, 1, 0));
        for (var pos: poses)
            if (tryEmitLight(serverWorld, pos, lightLevel)) break;
    }

    @Unique
    private void removeLightAt(class_3218 world, class_2338 pos) {
        if (world.method_8320(pos).method_27852(class_2246.field_31037)) {
            world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
        }
    }

    @Unique
    private boolean tryEmitLight(class_3218 serverWorld, class_2338 pos, int lightLevel) {
        if (lastLightPos != null && !lastLightPos.equals(pos)) {
            removeLightAt(serverWorld, lastLightPos);
            lastLightPos = null;
        }

        if (lightLevel > 0) {
            class_2680 existing = serverWorld.method_8320(pos);
            if (existing.method_26215() || existing.method_27852(class_2246.field_31037)) {
                class_2680 lightState = class_2246.field_31037.method_9564().method_11657(class_2741.field_12538, lightLevel);
                serverWorld.method_8652(pos, lightState, 3);
                lastLightPos = pos;
                return true;
            }
        } else if (lastLightPos != null) {
            removeLightAt(serverWorld, lastLightPos);
            lastLightPos = null;
        }
        return false;
    }

    @Inject(method = "remove", at = @At("HEAD"))
    public void remove(class_1297.class_5529 reason, CallbackInfo ci) {
        class_1309 entity = (class_1309) (Object) this;

        if (!entity.method_37908().field_9236 && lastLightPos != null) {
            removeLightAt((class_3218)entity.method_37908(), lastLightPos);
            lastLightPos = null;
        }
    }

    @Unique
    private boolean shouldEmitLight() {
        return hasStatusEffect(CustomEffects.AMETHYSM) || hasStatusEffect(class_1294.field_5912);
    }
}
