package com.bleudev.nine_lifes;

import com.bleudev.nine_lifes.custom.CustomDamageTypes;
import com.bleudev.nine_lifes.custom.CustomEffects;
import com.bleudev.nine_lifes.interfaces.mixin.BrewingStandBlockEntityCustomInterface;
import com.bleudev.nine_lifes.util.WorldUtils;
import java.util.Objects;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2589;
import net.minecraft.class_3218;
import net.minecraft.class_5575;
import net.minecraft.class_8956;
import net.minecraft.class_9334;

import static com.bleudev.nine_lifes.compat.VersionCompat.getPosCompat;

public class WindChargeTickFeatures {
    public static void do_for(class_3218 world, class_8956 wind_charge) {
        class_238 action_box = class_238.method_30048(getPosCompat(wind_charge), 3, 3, 3);
        WorldUtils.forBlocksInBox(action_box, (pos) -> {
            var blockEntity = world.method_8321(pos);
            if (blockEntity instanceof class_2589 brewing) {
                var inventory = ((BrewingStandBlockEntityCustomInterface) brewing).nine_lifes$getInventory();

                if (inventory.subList(0, 3).stream().noneMatch(potion -> {
                    try {
                        for (var eff: Objects.requireNonNull(potion.method_58694(class_9334.field_49651)).method_57397())
                            if (eff.method_5579().equals(CustomEffects.AMETHYSM))
                                return true;
                        return false;
                    } catch (NullPointerException ignored) { return false; }
                })) return;

                world.method_22352(pos, false);
                world.method_55117(
                        null, CustomDamageTypes.of(world, CustomDamageTypes.CHARGED_AMETHYST_DAMAGE_TYPE), null,
                        pos.method_10263(), pos.method_10264(), pos.method_10260(),
                        3f, true, class_1937.class_7867.field_40889
                );
            }
        });

        System.out.println(class_5575.method_31795(class_1309.class));

        world.method_8390(class_1309.class, action_box, ignored -> true).forEach(entity -> {
            entity.method_6016(CustomEffects.AMETHYSM);
        });

        world.method_18456().forEach(player -> {
            if (!action_box.method_1006(getPosCompat(player))) return;
            var inventory = player.method_31548();
            var inventory_updated = false;
            for (int slot = 0; slot < inventory.method_67533().size(); slot++) {
                var stack = inventory.method_5438(slot);
                var new_stack = stack.method_7972();

                class_1844 potion;
                if ((potion = stack.method_58694(class_9334.field_49651)) != null)
                    for (var effect: potion.method_57397())
                        if (effect.method_5579().equals(CustomEffects.AMETHYSM)) {
                            new_stack = class_1799.field_8037;
                            break;
                        }

                if (!class_1799.method_7973(stack, new_stack)) {
                    inventory.method_5447(slot, new_stack);
                    inventory_updated = true;
                }
            }

            if (inventory_updated)
                player.method_7353(class_2561.method_30163("Broke potions!"), false);
        });
    }
}
