package com.bleudev.nine_lifes.mixin;

import com.bleudev.nine_lifes.custom.CustomTags;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3920;
import net.minecraft.class_3924;
import net.minecraft.class_9696;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3924.class)
public abstract class CampfireBlockEntityMixin {
    @Shadow
    @Final
    private int[] cookingTimes;

    @Shadow
    public abstract class_2371<class_1799> getItemsBeingCooked();

    @Shadow
    @Final
    private int[] cookingTotalTimes;

    @Inject(method = "litServerTick", at = @At("HEAD"))
    private static void explode(class_3218 world, class_2338 pos, class_2680 state, class_3924 blockEntity, class_1863.class_7266<class_9696, class_3920> recipeMatchGetter, CallbackInfo ci) {
        var b_entity = (CampfireBlockEntityMixin) (Object) blockEntity;
        if (b_entity != null) {
            for (int slot = 0; slot < 4; slot++) {
                var stack = b_entity.getItemsBeingCooked().get(slot);
                if (stack.equals(class_1799.field_8037) || !stack.method_31573(CustomTags.CAUSE_CAMPFIRE_EXPLODE)) continue;
                var ticks = b_entity.cookingTotalTimes[slot] - b_entity.cookingTimes[slot];
                if (ticks == 1) {
                    world.method_22352(pos, false);
                    class_243 vec = pos.method_46558();
                    world.method_8537(null,
                        vec.method_10216(), vec.method_10214(), vec.method_10215(),
                        4f, true, class_1937.class_7867.field_40889
                    );
                }
            }
        }
    }
}
