package com.bleudev.nine_lifes.client;

import com.bleudev.nine_lifes.client.compat.modmenu.NineLifesConfig;
import com.bleudev.nine_lifes.client.custom.CustomEntityRenderers;
import com.bleudev.nine_lifes.networking.payloads.*;
import eu.midnightdust.lib.config.MidnightConfig;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.hud.VanillaHudElements;
import net.minecraft.class_10799;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_9779;
import net.minecraft.class_9848;
import org.jetbrains.annotations.NotNull;

import java.util.function.BiConsumer;
import java.util.function.Consumer;

import static com.bleudev.nine_lifes.ClientModStorage.*;
import static com.bleudev.nine_lifes.Nine_lifes.MOD_ID;
import static com.bleudev.nine_lifes.client.util.RenderingUtils.renderAnaglyph;
import static net.minecraft.class_155.field_29702;
import static net.minecraft.class_124.field_1062;
import static net.minecraft.class_124.field_1061;

public class Nine_lifesClient implements ClientModInitializer {
    public static final class_2960 OVERLAY_COLOR_BEFORE_HOTBAR = class_2960.method_60655(MOD_ID, "overlay_color_before_hotbar");
    public static final class_2960 OVERLAY_COLOR = class_2960.method_60655(MOD_ID, "overlay_color");
    public static final class_2960 CENTER_HEART = class_2960.method_60655(MOD_ID, "center_heart");

    private static final class_2960 QUESTION_MARK = class_2960.method_60655(MOD_ID, "textures/hud/sprites/question_mark.png");

    @Override
    public void onInitializeClient() {
        MidnightConfig.init(MOD_ID, NineLifesConfig.class);

        CustomEntityRenderers.initialize();

        HudElementRegistry.attachElementBefore(VanillaHudElements.HOTBAR, OVERLAY_COLOR_BEFORE_HOTBAR, this::renderOverlayColorBeforeHotBar);
        HudElementRegistry.attachElementAfter(VanillaHudElements.HOTBAR, CENTER_HEART, this::renderCenterHeart);
        HudElementRegistry.addLast(OVERLAY_COLOR, this::renderOverlayColor);

        ClientTickEvents.END_CLIENT_TICK.register(this::tick);

        ClientPlayNetworking.registerGlobalReceiver(JoinMessagePayload.ID, ((payload, context) -> {
            class_1934 gameMode = context.player().method_68876();
            if (NineLifesConfig.join_message_enabled && (gameMode == null ? class_1934.field_9215 : gameMode).method_8388()) {
                boolean careful = payload.lives() <= 5;
                context.player().method_7353(
                    class_2561.method_43469(careful ? "chat.message.join.lives.careful" : "chat.message.join.lives", payload.lives())
                    .method_27692(careful ? field_1061 : field_1062), false);
            }
        }));
        ClientPlayNetworking.registerGlobalReceiver(UpdateCenterHeartPayload.ID, (payload, context) -> lives = payload.lives());
        ClientPlayNetworking.registerGlobalReceiver(ArmorStandHitEventPayload.ID, (payload, context) -> {
            if (!armor_stand_hit_event_running)
                runArmorStandHitEvent();
        });
        ClientPlayNetworking.registerGlobalReceiver(StartWhitenessScreenEvent.ID, (payload, context) -> {
            max_whiteness_screen_ticks = payload.duration();
            max_whiteness_screen = payload.max_whiteness();
            whiteness_screen_ticks = 0;
            whiteness_screen_running = true;
        });
        ClientPlayNetworking.registerGlobalReceiver(StartAmethysmScreenEffectPayload.ID, (payload, context) ->
            amethysm_effect_info.start(payload.effect_ticks()));
    }

    private void renderCenterHeart(class_332 context, class_9779 tickCounter) {
        class_310 client = class_310.method_1551();

        class_1934 gameMode;
        if (client.field_1724 != null && (gameMode = client.field_1724.method_68876()) != null && !gameMode.method_8388()) return;

        class_2561 text = class_2561.method_43470("" + lives);

        int w = context.method_51421();
        int h = context.method_51443();
        int th = 18;

        float delta = (float) lives / 9;
        int color = class_9848.method_61318(0.75f, delta, delta, delta);

        Consumer<class_2960> drawCenterHeart = texture ->
            context.method_25291(class_10799.field_56883, texture, 0, -5, 0, 0, th, th, th, th, color);

        context.method_51448().pushMatrix();
        var v = center_heart_info.getOffsetAndScale();

        // Base center heart info
        BiConsumer<Integer, Integer> trans_pos = (dx, dy) ->
            context.method_51448().translate((float) (- th * v.method_10215()) / 2 + dx, h - 45 - (h - dy));

        switch (NineLifesConfig.heart_position) {
            case BOTTOM_LEFT -> trans_pos.accept(25, h + 20);
            case BOTTOM_CENTER -> trans_pos.accept(w / 2, h);
            case BOTTOM_RIGHT -> trans_pos.accept(w - 25, h + 20);
            case TOP_LEFT -> trans_pos.accept(25, 60);
            case TOP_CENTER -> trans_pos.accept(w / 2, 60);
            case TOP_RIGHT -> trans_pos.accept(w - 25, 60);
        }

        context.method_51448().translate((float) v.method_10216(), (float) v.method_10214());
        context.method_51448().scale((float) v.method_10215());
        drawCenterHeart.accept(class_2960.method_60656("textures/gui/sprites/hud/heart/container_hardcore.png"));
        drawCenterHeart.accept(class_2960.method_60656("textures/gui/sprites/hud/heart/hardcore_full.png"));
        context.method_27535(client.field_1772, text, client.field_1772.method_27525(text), 0, 0xffffffff);
        context.method_51448().popMatrix();
    }

    private void renderOverlayColorBeforeHotBar(class_332 context, class_9779 tickCounter) {
        Consumer<Integer> fill_overlay_color = color -> renderOverlayColor(context, color);

        fill_overlay_color.accept(class_9848.method_61318(0.5f * amethysm_purpleness, 0.5f, 0f, 0.5f));
    }

    private long lastMillis = 0;

    private void renderOverlayColor(class_332 context, class_9779 tickCounter) {
        Consumer<Integer> fill_overlay_color = color -> renderOverlayColor(context, color);

        fill_overlay_color.accept(class_9848.method_71346(amethysm_whiteness, 0xffffff));

        fill_overlay_color.accept(class_9848.method_71346(redness, 0xff0000));
        fill_overlay_color.accept(class_9848.method_71346(whiteness, 0xffffff));

        // Question marks
        long new_time = System.currentTimeMillis();
        if (lastMillis == 0) lastMillis = new_time;
        float delta_time = new_time - lastMillis;
        lastMillis = new_time;

        center_heart_info.tick(delta_time / 50);

        int w = context.method_51421();
        int h = context.method_51443();
        int qmh = h / 5;

        question_marks.forEach(i -> {
            var v = i.tick(delta_time / 50);
            context.method_51448().pushMatrix();
            context.method_51448().translate((float) (w * v.method_10216()) - (float) qmh / 2, (float) (h * v.method_10214()) - (float) qmh / 2);
            renderAnaglyph(context.method_51448(),
                c -> context.method_25291(class_10799.field_56883, QUESTION_MARK, 0, 0, 0, 0, qmh, qmh, qmh, qmh, c),
                i.getOffset(), class_9848.method_71346((float) v.method_10215(), 0xffffff));
            context.method_51448().popMatrix();
        });
        question_marks.removeIf(i -> i.getTime() >= i.getDuration());
    }

    private void renderOverlayColor(@NotNull class_332 context, int color) {
        context.method_25294(0, 0, context.method_51421(), context.method_51443(), color);
    }

    private void tick(class_310 client) {
        amethysm_effect_info.tick();
        if (max_heartbeat_ticks == 0)
            max_heartbeat_ticks = get_next_heartbeat_time(client.field_1724);

        if (heartbeat_ticks == 0 && client.field_1724 != null && client.field_1724.method_5805())
            center_heart_info.do_heartbeat(2f);
        heartbeat_ticks++;
        if (heartbeat_ticks == max_heartbeat_ticks) {
            heartbeat_ticks = 0;
            max_heartbeat_ticks = get_next_heartbeat_time(client.field_1724);
        }

        if (armor_stand_hit_event_running) {
            if (armor_stand_hit_event_ticks == 0)
                armor_stand_hit_event_running = false;
            else {
                armor_stand_hit_event_ticks--;

                var from_ticks = 2 * field_29702 - armor_stand_hit_event_ticks;

                if (from_ticks <= .5 * field_29702)
                    armor_stand_hit_redness = class_3532.method_16439(from_ticks / (.5f * field_29702), 0f, 1f);
                else
                    armor_stand_hit_redness = class_3532.method_16439((from_ticks - .5f * field_29702) / (1.5f * field_29702), 1f, 0f);
            }
        }

        redness = class_3532.method_16439(armor_stand_hit_redness, 0f, .2f);

        if (whiteness_screen_running) {
            if (whiteness_screen_ticks == max_whiteness_screen_ticks)
                whiteness_screen_running = false;
            else {
                whiteness_screen_ticks++;

                whiteness = class_3532.method_16439((float) whiteness_screen_ticks / max_whiteness_screen_ticks, 0f, max_whiteness_screen);
            }
        }
        else whiteness = 0f;
    }

    private void runArmorStandHitEvent() {
        armor_stand_hit_event_running = true;
        armor_stand_hit_event_ticks = 2 * field_29702;
    }
}
