package com.bleudev.nine_lifes.custom.consume;

import com.bleudev.nine_lifes.custom.CustomEffects;
import com.bleudev.nine_lifes.custom.CustomEnchantments;
import com.bleudev.nine_lifes.interfaces.mixin.LivingEntityCustomInterface;
import com.bleudev.nine_lifes.networking.payloads.StartWhitenessScreenEvent;
import com.bleudev.nine_lifes.util.LivesUtils;
import com.mojang.serialization.MapCodec;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_10134;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

import static com.bleudev.nine_lifes.custom.CustomConsumeEffectTypes.AMETHYSM_CONSUME_EFFECT_TYPE;
import static net.minecraft.class_155.field_29702;

public record AmethysmConsumeEffect() implements class_10134 {
    public static final AmethysmConsumeEffect INSTANCE = new AmethysmConsumeEffect();
    public static final MapCodec<AmethysmConsumeEffect> CODEC = MapCodec.unit(INSTANCE);
    public static final class_9139<class_9129, AmethysmConsumeEffect> PACKET_CODEC = class_9139.method_56431(INSTANCE);

    @Override
    public class_10135<? extends class_10134> method_62864() {
        return AMETHYSM_CONSUME_EFFECT_TYPE;
    }

    @Override
    public boolean method_62866(class_1937 world, class_1799 stack, class_1309 entity) {
        if (stack.method_58657().method_57534().stream()
            .anyMatch(entry -> entry.method_40230()
                .map(key -> key.equals(CustomEnchantments.CHARGE))
                .orElse(false))) {
            if (entity instanceof class_3222 player) {
                LivesUtils.setLives(player, o -> o + 2);
                ServerPlayNetworking.send(player, new StartWhitenessScreenEvent(field_29702));
            }

            ((LivingEntityCustomInterface) entity).nine_lifes$setDamageTicks(field_29702);
            return true;
        }

        if (entity instanceof class_1657 player) {
            player.method_7353(class_2561.method_43470("- .... .  .--. --- .-- . .-.  --- ..-.  .- -- . - .... -.-- ... -  .. ...  - --- ---  ... - .-. --- -. --.").method_27692(class_124.field_1076), true);
        }

        return entity.method_6092(new class_1293(CustomEffects.AMETHYSM, 5 * field_29702, 0));
    }
}
