package com.bleudev.nine_lifes.util;

import com.bleudev.nine_lifes.custom.CustomEffects;
import com.bleudev.nine_lifes.interfaces.mixin.ServerPlayerEntityCustomInteface;
import com.bleudev.nine_lifes.networking.payloads.UpdateCenterHeartPayload;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1293;
import net.minecraft.class_1934;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import java.util.function.Function;

import static net.minecraft.class_155.field_29702;

public class LivesUtils {
    public static final int MAX_LIVES = 9;

    private static int clamp(int lives) {
        return class_3532.method_15340(lives, 0, MAX_LIVES);
    }

    public static int getLives(class_3222 player) {
        return clamp(((ServerPlayerEntityCustomInteface) player).nine_lifes$getLives());
    }

    public static void setLives(class_3222 player, int new_lives) {
        new_lives = clamp(new_lives);
        ((ServerPlayerEntityCustomInteface) player).nine_lifes$setLives(new_lives);
        ServerPlayNetworking.send(player, new UpdateCenterHeartPayload(new_lives));
    }
    public static void setLives(class_3222 player, Function<Integer, Integer> changer) {
        setLives(player, changer.apply(getLives(player)));
    }

    public static void resetLives(class_3222 player) {
        setLives(player, MAX_LIVES);
    }

    public static void revive(class_3222 player) {
        resetLives(player);
        if (player.method_7325())
            player.method_7336(class_1934.field_9215);
        player.method_6092(new class_1293(CustomEffects.AMETHYSM, 5 * field_29702, 0));
    }
}
