/*
 * Decompiled with CFR 0.152.
 */
package com.bleudev.nine_lifes.client;

import com.bleudev.nine_lifes.ClientModStorage;
import com.bleudev.nine_lifes.client.compat.modmenu.NineLifesConfig;
import com.bleudev.nine_lifes.client.custom.CustomEntityRenderers;
import com.bleudev.nine_lifes.client.util.RenderingUtils;
import com.bleudev.nine_lifes.networking.payloads.ArmorStandHitEventPayload;
import com.bleudev.nine_lifes.networking.payloads.JoinMessagePayload;
import com.bleudev.nine_lifes.networking.payloads.StartAmethysmScreenEffectPayload;
import com.bleudev.nine_lifes.networking.payloads.StartWhitenessScreenEvent;
import com.bleudev.nine_lifes.networking.payloads.UpdateCenterHeartPayload;
import eu.midnightdust.lib.config.MidnightConfig;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.hud.VanillaHudElements;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_1934;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_9779;
import net.minecraft.class_9848;
import org.jetbrains.annotations.NotNull;

public class Nine_lifesClient
implements ClientModInitializer {
    public static final class_2960 OVERLAY_COLOR_BEFORE_HOTBAR = class_2960.method_60655((String)"nine_lifes", (String)"overlay_color_before_hotbar");
    public static final class_2960 OVERLAY_COLOR = class_2960.method_60655((String)"nine_lifes", (String)"overlay_color");
    public static final class_2960 CENTER_HEART = class_2960.method_60655((String)"nine_lifes", (String)"center_heart");
    private static final class_2960 QUESTION_MARK = class_2960.method_60655((String)"nine_lifes", (String)"textures/hud/sprites/question_mark.png");
    private long lastMillis = 0L;

    public void onInitializeClient() {
        MidnightConfig.init((String)"nine_lifes", NineLifesConfig.class);
        CustomEntityRenderers.initialize();
        HudElementRegistry.attachElementBefore((class_2960)VanillaHudElements.HOTBAR, (class_2960)OVERLAY_COLOR_BEFORE_HOTBAR, this::renderOverlayColorBeforeHotBar);
        HudElementRegistry.attachElementAfter((class_2960)VanillaHudElements.HOTBAR, (class_2960)CENTER_HEART, this::renderCenterHeart);
        HudElementRegistry.addLast((class_2960)OVERLAY_COLOR, this::renderOverlayColor);
        ClientTickEvents.END_CLIENT_TICK.register(this::tick);
        ClientPlayNetworking.registerGlobalReceiver(JoinMessagePayload.ID, (payload, context) -> {
            class_1934 gameMode = context.player().method_68876();
            if (NineLifesConfig.join_message_enabled && (gameMode == null ? class_1934.field_9215 : gameMode).method_8388()) {
                boolean careful = payload.lives() <= 5;
                context.player().method_7353((class_2561)class_2561.method_43469((String)(careful ? "chat.message.join.lives.careful" : "chat.message.join.lives"), (Object[])new Object[]{payload.lives()}).method_27692(careful ? class_124.field_1061 : class_124.field_1062), false);
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(UpdateCenterHeartPayload.ID, (payload, context) -> {
            ClientModStorage.lives = payload.lives();
        });
        ClientPlayNetworking.registerGlobalReceiver(ArmorStandHitEventPayload.ID, (payload, context) -> {
            if (!ClientModStorage.armor_stand_hit_event_running) {
                this.runArmorStandHitEvent();
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(StartWhitenessScreenEvent.ID, (payload, context) -> {
            ClientModStorage.max_whiteness_screen_ticks = payload.duration();
            ClientModStorage.max_whiteness_screen = payload.max_whiteness().floatValue();
            ClientModStorage.whiteness_screen_ticks = 0;
            ClientModStorage.whiteness_screen_running = true;
        });
        ClientPlayNetworking.registerGlobalReceiver(StartAmethysmScreenEffectPayload.ID, (payload, context) -> ClientModStorage.amethysm_effect_info.start(payload.effect_ticks()));
    }

    private void renderCenterHeart(class_332 context, class_9779 tickCounter) {
        class_1934 gameMode;
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null && (gameMode = client.field_1724.method_68876()) != null && !gameMode.method_8388()) {
            return;
        }
        class_5250 text = class_2561.method_43470((String)("" + ClientModStorage.lives));
        int w = context.method_51421();
        int h = context.method_51443();
        int th = 18;
        float delta = (float)ClientModStorage.lives / 9.0f;
        int color = class_9848.method_61318((float)0.75f, (float)delta, (float)delta, (float)delta);
        Consumer<class_2960> drawCenterHeart = texture -> context.method_25291(class_10799.field_56883, texture, 0, -5, 0.0f, 0.0f, th, th, th, th, color);
        context.method_51448().pushMatrix();
        class_243 v = ClientModStorage.center_heart_info.getOffsetAndScale();
        BiConsumer<Integer, Integer> trans_pos = (dx, dy) -> context.method_51448().translate((float)((double)(-th) * v.method_10215()) / 2.0f + (float)dx.intValue(), (float)(h - 45 - (h - dy)));
        switch (NineLifesConfig.heart_position) {
            case BOTTOM_LEFT: {
                trans_pos.accept(25, h + 20);
                break;
            }
            case BOTTOM_CENTER: {
                trans_pos.accept(w / 2, h);
                break;
            }
            case BOTTOM_RIGHT: {
                trans_pos.accept(w - 25, h + 20);
                break;
            }
            case TOP_LEFT: {
                trans_pos.accept(25, 60);
                break;
            }
            case TOP_CENTER: {
                trans_pos.accept(w / 2, 60);
                break;
            }
            case TOP_RIGHT: {
                trans_pos.accept(w - 25, 60);
            }
        }
        context.method_51448().translate((float)v.method_10216(), (float)v.method_10214());
        context.method_51448().scale((float)v.method_10215());
        drawCenterHeart.accept(class_2960.method_60656((String)"textures/gui/sprites/hud/heart/container_hardcore.png"));
        drawCenterHeart.accept(class_2960.method_60656((String)"textures/gui/sprites/hud/heart/hardcore_full.png"));
        context.method_27535(client.field_1772, (class_2561)text, client.field_1772.method_27525((class_5348)text), 0, -1);
        context.method_51448().popMatrix();
    }

    private void renderOverlayColorBeforeHotBar(class_332 context, class_9779 tickCounter) {
        Consumer<Integer> fill_overlay_color = color -> this.renderOverlayColor(context, (int)color);
        fill_overlay_color.accept(class_9848.method_61318((float)(0.5f * ClientModStorage.amethysm_purpleness), (float)0.5f, (float)0.0f, (float)0.5f));
    }

    private void renderOverlayColor(class_332 context, class_9779 tickCounter) {
        Consumer<Integer> fill_overlay_color = color -> this.renderOverlayColor(context, (int)color);
        fill_overlay_color.accept(class_9848.method_71346((float)ClientModStorage.amethysm_whiteness, (int)0xFFFFFF));
        fill_overlay_color.accept(class_9848.method_71346((float)ClientModStorage.redness, (int)0xFF0000));
        fill_overlay_color.accept(class_9848.method_71346((float)ClientModStorage.whiteness, (int)0xFFFFFF));
        long new_time = System.currentTimeMillis();
        if (this.lastMillis == 0L) {
            this.lastMillis = new_time;
        }
        float delta_time = new_time - this.lastMillis;
        this.lastMillis = new_time;
        ClientModStorage.center_heart_info.tick(delta_time / 50.0f);
        int w = context.method_51421();
        int h = context.method_51443();
        int qmh = h / 5;
        ClientModStorage.question_marks.forEach(i -> {
            class_243 v = i.tick(delta_time / 50.0f);
            context.method_51448().pushMatrix();
            context.method_51448().translate((float)((double)w * v.method_10216()) - (float)qmh / 2.0f, (float)((double)h * v.method_10214()) - (float)qmh / 2.0f);
            RenderingUtils.renderAnaglyph(context.method_51448(), c -> context.method_25291(class_10799.field_56883, QUESTION_MARK, 0, 0, 0.0f, 0.0f, qmh, qmh, qmh, qmh, c.intValue()), i.getOffset(), class_9848.method_71346((float)((float)v.method_10215()), (int)0xFFFFFF));
            context.method_51448().popMatrix();
        });
        ClientModStorage.question_marks.removeIf(i -> i.getTime() >= (float)i.getDuration());
    }

    private void renderOverlayColor(@NotNull class_332 context, int color) {
        context.method_25294(0, 0, context.method_51421(), context.method_51443(), color);
    }

    private void tick(class_310 client) {
        ClientModStorage.amethysm_effect_info.tick();
        if (ClientModStorage.max_heartbeat_ticks == 0) {
            ClientModStorage.max_heartbeat_ticks = ClientModStorage.get_next_heartbeat_time(client.field_1724);
        }
        if (ClientModStorage.heartbeat_ticks == 0 && client.field_1724 != null && client.field_1724.method_5805()) {
            ClientModStorage.center_heart_info.do_heartbeat(2.0f);
        }
        if (++ClientModStorage.heartbeat_ticks == ClientModStorage.max_heartbeat_ticks) {
            ClientModStorage.heartbeat_ticks = 0;
            ClientModStorage.max_heartbeat_ticks = ClientModStorage.get_next_heartbeat_time(client.field_1724);
        }
        if (ClientModStorage.armor_stand_hit_event_running) {
            if (ClientModStorage.armor_stand_hit_event_ticks == 0) {
                ClientModStorage.armor_stand_hit_event_running = false;
            } else {
                int from_ticks;
                ClientModStorage.armor_stand_hit_redness = (double)(from_ticks = 40 - --ClientModStorage.armor_stand_hit_event_ticks) <= 10.0 ? class_3532.method_16439((float)((float)from_ticks / 10.0f), (float)0.0f, (float)1.0f) : class_3532.method_16439((float)(((float)from_ticks - 10.0f) / 30.0f), (float)1.0f, (float)0.0f);
            }
        }
        ClientModStorage.redness = class_3532.method_16439((float)ClientModStorage.armor_stand_hit_redness, (float)0.0f, (float)0.2f);
        if (ClientModStorage.whiteness_screen_running) {
            if (ClientModStorage.whiteness_screen_ticks == ClientModStorage.max_whiteness_screen_ticks) {
                ClientModStorage.whiteness_screen_running = false;
            } else {
                ClientModStorage.whiteness = class_3532.method_16439((float)((float)(++ClientModStorage.whiteness_screen_ticks) / (float)ClientModStorage.max_whiteness_screen_ticks), (float)0.0f, (float)ClientModStorage.max_whiteness_screen);
            }
        } else {
            ClientModStorage.whiteness = 0.0f;
        }
    }

    private void runArmorStandHitEvent() {
        ClientModStorage.armor_stand_hit_event_running = true;
        ClientModStorage.armor_stand_hit_event_ticks = 40;
    }
}

