package com.bleudev.nine_lifes;

import com.bleudev.nine_lifes.compat.VersionCompat;
import com.bleudev.nine_lifes.custom.*;
import com.bleudev.nine_lifes.custom.event.EntitySpawnEvents;
import com.bleudev.nine_lifes.interfaces.mixin.LivingEntityCustomInterface;
import com.bleudev.nine_lifes.networking.Packets;
import com.bleudev.nine_lifes.networking.payloads.JoinMessage;
import com.bleudev.nine_lifes.networking.payloads.StartChargeScreenEffect;
import com.bleudev.nine_lifes.networking.payloads.UpdateCenterHeart;
import com.bleudev.nine_lifes.util.ComponentUtils;
import com.bleudev.nine_lifes.util.LivesUtils;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.registry.FabricBrewingRecipeRegistryBuilder;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1802;
import net.minecraft.class_1847;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5361;

import static com.bleudev.nine_lifes.NineLifesConst.*;
import static com.bleudev.nine_lifes.compat.VersionCompat.getPosCompat;
import static com.bleudev.nine_lifes.util.ComponentUtils.item_ensure_custom_foods;
import static com.bleudev.nine_lifes.util.ComponentUtils.should_update_amethyst_shard;

public class Nine_lifes implements ModInitializer {
    @Deprecated(since = "1.9.1")
    public static final String MOD_ID = NineLifesConst.MOD_ID;

    @Override
    public void onInitialize() {
        Packets.initialize();
        CustomEffects.initialize();
        CustomConsumeEffectTypes.initialize();
        CustomEnchantments.initialize();
        CustomPotions.initialize();
        CustomEntities.initialize();
        FabricBrewingRecipeRegistryBuilder.BUILD.register(builder ->
            builder.method_59705(class_1847.field_8991, class_1802.field_27063, CustomPotions.AMETHYSM));
        ServerPlayerEvents.JOIN.register(player -> {
            if ((!player.method_7325()) && (LivesUtils.getLives(player) == 0))
                LivesUtils.resetLives(player);
            ServerPlayNetworking.send(player, new UpdateCenterHeart(LivesUtils.getLives(player)));
            ServerPlayNetworking.send(player, new JoinMessage(LivesUtils.getLives(player)));
            BetaModeHelper.trySendBetaModeMessage(player);
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            // Custom food (amethyst shard)
            for (var player: server.method_3760().method_14571())
                ComponentUtils.player_ensure_custom_foods(player);

            // Find all amethyst shard item entities in `amethyst_shard_find_radius`
            double amethyst_shard_find_radius = 20;
            for (var world: server.method_3738()) {
                for (var player: world.method_18456()) {
                    var box = class_238.method_30048(getPosCompat(player), amethyst_shard_find_radius, amethyst_shard_find_radius, amethyst_shard_find_radius);
                    world.method_18023(
                        class_1299.field_6052,
                        box,
                        entity -> entity.method_6983().method_31574(class_1802.field_27063) &&
                                         should_update_amethyst_shard(entity.method_6983())
                    ).forEach(entity -> entity.method_6979(item_ensure_custom_foods(entity.method_6983())));
                    world.method_8390(class_1309.class, box, ignored -> true).forEach(entity -> {
                        var inter = (LivingEntityCustomInterface) entity;
                        int damage_ticks = inter.nine_lifes$getDamageTicks();
                        if (damage_ticks == -1) return;

                        if (damage_ticks == 0) {
                            world.method_55117(
                                    entity, CustomDamageTypes.of(world, CustomDamageTypes.CHARGED_AMETHYST_DAMAGE_TYPE), new class_5361(entity),
                                    entity.method_23317(), entity.method_23318(), entity.method_23321(),
                                    7f, true, class_1937.class_7867.field_40890
                            );
                            entity.method_64397(world,
                                CustomDamageTypes.of(entity, CustomDamageTypes.CHARGED_AMETHYST_DAMAGE_TYPE),
                                1000f
                            );
                        }
                        inter.nine_lifes$setDamageTicks(--damage_ticks);
                    });
                }
                tryChargeItems(world);
            }

            // Wind charges
            for (var world: server.method_3738())
                world.method_18198(class_1299.field_47243, ignored -> true).forEach(wind_charge ->
                    WindChargeTickFeatures.do_for(world, wind_charge));
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) ->
            CustomCommands.initialize(dispatcher));
        EntitySpawnEvents.ENTITY_SPAWN.register((entity, world) -> {
            // If it's armor stand
            if (entity.method_5864().equals(class_1299.field_6131)) {
                // Then try spawn wandering one
                if (world.method_8409().method_43057() < WANDERING_ARMOR_STAND_SPAWN_CHANCE) {
                    var newEntity = CustomEntities.WANDERING_ARMOR_STAND_TYPE.method_5883(world, class_3730.field_16465);
                    if (newEntity != null) {
                        newEntity.method_60949(VersionCompat.getPosCompat(entity), entity.method_36454(), entity.method_36455());
                        world.method_8649(newEntity);
                        entity.method_31472();
                    }
                }
            }
        });
    }

    private void tryChargeItems(class_3218 world) {
        var charge_screen_effect_radius_diff = CHARGE_SCREEN_EFFECT_RADIUS_MAX - CHARGE_SCREEN_EFFECT_RADIUS_MIN;

        final var CHARGE_ENCHANTMENT = CustomEnchantments.Entries.create(world.method_30349()).charge();
        world.method_18198(class_1299.field_6112, ignored -> true).forEach(lightning ->
            world.method_18023(class_1299.field_6052,
                class_238.method_30048(getPosCompat(lightning), LIGHTNING_CHARGING_RADIUS, LIGHTNING_CHARGING_RADIUS, LIGHTNING_CHARGING_RADIUS),
                entity -> entity.method_6983().method_31573(CustomTags.ItemTags.LIGHTNING_CHARGEABLE))
            .forEach(item_entity -> {
                var stack = item_entity.method_6983();
                if (!stack.method_58657().method_57534().contains(CHARGE_ENCHANTMENT)) {
                    stack.method_7978(CHARGE_ENCHANTMENT, 1);
                    item_entity.method_6979(stack);

                    world.method_18456().forEach(player -> {
                        var distance = Math.max(getPosCompat(player).method_1022(getPosCompat(item_entity)) - CHARGE_SCREEN_EFFECT_RADIUS_MIN, 0);
                        var strength = CHARGE_SCREEN_MAX_STRENGTH * (charge_screen_effect_radius_diff - distance) / charge_screen_effect_radius_diff;
                        ServerPlayNetworking.send(player, new StartChargeScreenEffect(CHARGE_SCREEN_DURATION, (float) strength));
                    });
                }
        }));
    }
}
