package com.bleudev.nine_lifes.client.util;

import org.joml.Matrix3x2fStack;

import java.util.function.Consumer;
import net.minecraft.class_9848;

public class RenderingUtils {
    public static void renderAnaglyph(Matrix3x2fStack matrix, Consumer<Integer> renderer, float offsetX, float offsetY, int base_color) {
        float a = class_9848.method_65100(base_color);
        float r = class_9848.method_65101(base_color);
        float g = class_9848.method_65102(base_color);
        float b = class_9848.method_65103(base_color);

        // Light blue side
        matrix.translate(+offsetX, +offsetY);
        renderer.accept(class_9848.method_61318(a, 0, g, b));
        // Red side
        matrix.translate(-2*offsetX, -2*offsetY);
        renderer.accept(class_9848.method_61318(a, r, 0, 0));
        // Normal side
        matrix.translate(+offsetX, +offsetY);
        renderer.accept(base_color);
    }
    public static void renderAnaglyph(Matrix3x2fStack matrix, Consumer<Integer> renderer, float offsetX, int base_color) {
        renderAnaglyph(matrix, renderer, offsetX, 0, base_color);
    }
    public static void renderAnaglyph(Matrix3x2fStack matrix, Consumer<Integer> renderer, float offsetX) {
        renderAnaglyph(matrix, renderer, offsetX, 0xffffffff);
    }
}
