package com.bleudev.nine_lifes.custom;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

import static com.bleudev.nine_lifes.NineLifesConst.MOD_ID;

import net.minecraft.class_1887;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

/**
 * Class which provides custom {@link class_1887 enchantments} added in Nine lifes mod(
 * {@code nine_lifes:charge}
 * )
 * */
public class CustomEnchantments {
    private CustomEnchantments() {}

    /**
     * {@link class_5321} of {@code nine_lifes:charge} enchantment
     * */
    public static final class_5321<class_1887> CHARGE = of("charge");

    private static class_5321<class_1887> of(String name) {
        return class_5321.method_29179(class_7924.field_41265, class_2960.method_60655(MOD_ID, name));
    }

    /**
     * Class which provides functions and methods to get enchantment {@link class_6880 registry entries} with provided {@link class_5455}
     *
     * <pre>{@code
     * // Simple example
     * CustomEnchantments.Entries.create(world.getRegistryManager()).charge()
     * // Or
     * CustomEnchantments.Entries.charge(world.getRegistryManager())
     * }</pre>
     * */
    public static class Entries {
        private final class_5455 manager;

        private Entries(class_5455 manager) {
            this.manager = manager;
        }

        private @NotNull class_6880<class_1887> getEntry(class_5321<class_1887> key) {
            return class_6880.method_40223(manager.method_30530(class_7924.field_41265).method_29107(key));
        }

        // Public nonstatic
        /**
         * {@link class_6880} of {@code nine_lifes:charge} enchantment
         *
         * @return registry entry of enchantment
         * */
        public class_6880<class_1887> charge() {
            return getEntry(CustomEnchantments.CHARGE);
        }

        // Public static
        /**
         * Create new {@link Entries} object from provided {@link class_5455}
         *
         * @param manager Registry manager to use in created object
         * @return new {@link Entries} object
         * */
        @Contract(value = "_ -> new", pure = true)
        public static @NotNull Entries create(class_5455 manager) {
            return new Entries(manager);
        }

        /**
         * {@link class_6880} of {@code nine_lifes:charge} enchantment
         *
         * @param manager Registry manager where to get entry
         * @return registry entry of enchantment
         * */
        public static class_6880<class_1887> charge(class_5455 manager) {
            return create(manager).charge();
        }
    }

    /**
     * Deprecated since 1.9 version and will be deleted in 1.10.
     * Use {@link Entries} functions or methods instead
     * <pre>{@code
     * // Replace this line
     * CustomEnchantments.getEntry(world.getRegistryManager(), CustomEnchantments.CHARGE)
     * // With
     * CustomEnchantments.Entries.create(world.getRegistryManager()).charge()
     * }</pre>
     * */
    @Contract("_, _ -> new")
    @Deprecated(since = "1.9")
    public static @NotNull class_6880<class_1887> getEntry(class_5455 manager, class_5321<class_1887> key) {
        return Entries.create(manager).getEntry(key);
    }

    /**
     * [DANGER]
     * Do not use in mods depends on Nine Lifes!
     * */
    public static void initialize() {
    }
}
