package com.bleudev.nine_lifes.custom.event;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1297;
import net.minecraft.class_3218;

public class EntitySpawnEvents {
    public static final Event<EntitySpawn> ENTITY_SPAWN = EventFactory.createArrayBacked(EntitySpawn.class, callbacks -> ((entity, world) -> {
        for (EntitySpawn callback : callbacks)
            callback.onEntitySpawn(entity, world);
    }));

    @FunctionalInterface
    public interface EntitySpawn {
        void onEntitySpawn(class_1297 entity, class_3218 world);
    }
}