package com.bleudev.nine_lifes;

import com.bleudev.nine_lifes.custom.*;
import com.bleudev.nine_lifes.interfaces.mixin.LivingEntityCustomInterface;
import com.bleudev.nine_lifes.networking.Packets;
import com.bleudev.nine_lifes.networking.payloads.JoinMessagePayload;
import com.bleudev.nine_lifes.networking.payloads.UpdateCenterHeartPayload;
import com.bleudev.nine_lifes.util.ComponentUtils;
import com.bleudev.nine_lifes.util.LivesUtils;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.registry.FabricBrewingRecipeRegistryBuilder;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1802;
import net.minecraft.class_1847;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_5361;

import static com.bleudev.nine_lifes.util.ComponentUtils.item_ensure_custom_foods;
import static com.bleudev.nine_lifes.util.ComponentUtils.should_update_amethyst_shard;

public class Nine_lifes implements ModInitializer {
    public static final String MOD_ID = "nine_lifes";
    public static final String NAME = "Nine lifes";
    public static final String AUTHOR = "bleudev";
    public static final String VERSION = "1.7.1b";
    public static final String GITHUB_LINK = "https://github.com/bleudev/nine_lifes";
    public static final String MODRINTH_LINK = "https://modrinth.com/mod/nine_lifes";

    @Override
    public void onInitialize() {
        Packets.initialize();
        CustomEffects.initialize();
        CustomConsumeEffectTypes.initialize();
        CustomEnchantments.initialize();
        CustomPotions.initialize();
        CustomEntities.initialize();
        FabricBrewingRecipeRegistryBuilder.BUILD.register(builder -> {
            builder.method_59705(class_1847.field_8991, class_1802.field_27063, CustomPotions.AMETHYSM);
        });
        ServerPlayerEvents.JOIN.register(player -> {
            if ((!player.method_7325()) && (LivesUtils.getLives(player) == 0))
                LivesUtils.resetLives(player);
            ServerPlayNetworking.send(player, new UpdateCenterHeartPayload(LivesUtils.getLives(player)));
            ServerPlayNetworking.send(player, new JoinMessagePayload(LivesUtils.getLives(player)));
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            // Custom food (amethyst shard)
            for (var player: server.method_3760().method_14571())
                ComponentUtils.player_ensure_custom_foods(player);

            // Find all amethyst shard item entities in `find_radius`
            double find_radius = 20;
            for (var world: server.method_3738())
                for (var player: world.method_18456()) {
                    var box = class_238.method_30048(player.method_19538(), find_radius, find_radius, find_radius);
                    world.method_18023(
                        class_1299.field_6052,
                        box,
                        entity -> entity.method_6983().method_31574(class_1802.field_27063) &&
                                         should_update_amethyst_shard(entity.method_6983())
                    ).forEach(entity -> entity.method_6979(item_ensure_custom_foods(entity.method_6983())));
                    world.method_8390(class_1309.class, box, ignored -> true).forEach(entity -> {
                        var inter = (LivingEntityCustomInterface) entity;
                        int damage_ticks = inter.nine_lifes$getDamageTicks();
                        if (damage_ticks == -1) return;

                        if (damage_ticks == 0) {
                            world.method_55117(
                                    entity, CustomDamageTypes.of(world, CustomDamageTypes.CHARGED_AMETHYST_DAMAGE_TYPE), new class_5361(entity),
                                    entity.method_23317(), entity.method_23318(), entity.method_23321(),
                                    7f, true, class_1937.class_7867.field_40890
                            );
                            entity.method_64397(world,
                                CustomDamageTypes.of(entity, CustomDamageTypes.CHARGED_AMETHYST_DAMAGE_TYPE),
                                1000f
                            );
                        }
                        inter.nine_lifes$setDamageTicks(--damage_ticks);
                    });
                }

            // Wind charges
            for (var world: server.method_3738())
                world.method_18198(class_1299.field_47243, ignored -> true).forEach(wind_charge -> {
                    WindChargeTickFeatures.do_for(world, wind_charge);
                });
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            CustomCommands.initialize(dispatcher);
        });
    }
}
