package com.bleudev.nine_lifes.mixin;

import com.bleudev.nine_lifes.custom.CustomTags;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.HashMap;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2591;
import net.minecraft.class_2609;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3956;
import net.minecraft.class_6862;

@Mixin(class_2609.class)
public class AbstractFurnaceBlockEntityMixin {
    @Shadow
    protected class_2371<class_1799> inventory;

    @Mutable
    @Unique
    @Final
    protected class_3956 type;

    @Inject(method = "<init>", at = @At("RETURN"))
    private void init(class_2591 blockEntityType, class_2338 pos, class_2680 state, class_3956 recipeType, CallbackInfo ci) {
        type = recipeType;
    }

    @Inject(method = "tick", at = @At("RETURN"))
    private static void tick(class_3218 world, class_2338 pos, class_2680 state, class_2609 blockEntity, CallbackInfo ci) {
        var mixin = (AbstractFurnaceBlockEntityMixin) (Object) blockEntity;
        assert mixin != null;
        class_2371<class_1799> inv = mixin.inventory;
        class_1799 output = inv.get(2);

        var tags = new HashMap<class_3956<?>, class_6862<class_1792>>();
        tags.put(class_3956.field_17546, CustomTags.CAUSE_FURNACE_EXPLODE);
        tags.put(class_3956.field_17547, CustomTags.CAUSE_BLAST_FURNACE_EXPLODE);
        tags.put(class_3956.field_17548, CustomTags.CAUSE_SMOKER_EXPLODE);

        if (!tags.containsKey(mixin.type)) return;

        if (!output.method_7960() && output.method_31573(tags.get(mixin.type))) {
            inv.set(2, class_1799.field_8037);
            world.method_22352(pos, false);
            class_243 vec = pos.method_46558();
            world.method_8537(null,
                vec.method_10216(), vec.method_10214(), vec.method_10215(),
                4f, true, class_1937.class_7867.field_40889
            );
        }
    }
}
