/*
 * Decompiled with CFR 0.152.
 */
package com.bleudev.nine_lifes;

import com.bleudev.nine_lifes.client.compat.modmenu.NineLifesConfig;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;

@Environment(value=EnvType.CLIENT)
public class ClientModStorage {
    public static int lives = 9;
    public static int armor_stand_hit_event_ticks = 0;
    public static boolean armor_stand_hit_event_running = false;
    public static float max_whiteness_screen = 0.0f;
    public static int max_whiteness_screen_ticks = 0;
    public static int whiteness_screen_ticks = 0;
    public static boolean whiteness_screen_running = false;
    public static float whiteness = 0.0f;
    public static float redness = 0.0f;
    public static float amethysm_whiteness = 0.0f;
    public static float amethysm_purpleness = 0.0f;
    public static float armor_stand_hit_redness = 0.0f;
    public static AmethysmEffectInfo amethysm_effect_info = new AmethysmEffectInfo();
    public static ArrayList<DynamicQuestionMarkInfo> question_marks = new ArrayList();
    public static CenterHeartInfo center_heart_info = new CenterHeartInfo();
    public static int heartbeat_ticks = 0;
    public static int max_heartbeat_ticks = 1;

    private static <T extends class_1657> int get_next_heartbeat_rate(@Nullable T player) {
        Random random = new Random();
        int ans = random.nextInt(70, 90);
        if (player != null) {
            ans += (int)Math.floor(player.method_6063() - player.method_6032()) * 2;
            if (!player.method_5805()) {
                ans -= 9999;
            }
        }
        if (lives == 0) {
            ans -= 9999;
        }
        return class_3532.method_15340((int)(ans -= (9 - lives) * 5), (int)0, (int)Integer.MAX_VALUE);
    }

    public static <T extends class_1657> int get_next_heartbeat_time(@Nullable T player) {
        int rate = ClientModStorage.get_next_heartbeat_rate(player);
        if (rate == 0) {
            return 1;
        }
        float in_second = (float)rate / 60.0f;
        return Math.round(1.0f / in_second * 20.0f);
    }

    public static class AmethysmEffectInfo {
        private boolean running = false;
        private int ticks = 0;
        private int duration;

        public void start(int duration) {
            this.running = true;
            this.ticks = 0;
            this.duration = duration;
        }

        public void tick() {
            if (this.running) {
                if (this.ticks < this.duration) {
                    if (this.ticks % 15 == 0) {
                        question_marks.add(new DynamicQuestionMarkInfo(0.5f, 0.5f, 0.25f, 40));
                    }
                    int WHITENESS_START = 5;
                    int WHITENESS_END_FROM_DURATION_END = 10;
                    if (this.ticks < 5) {
                        amethysm_whiteness = (float)this.ticks / 5.0f;
                    } else if (this.ticks < this.duration - 10) {
                        amethysm_whiteness = 1.0f - (float)(this.ticks - 5) / (float)(this.duration - 5 - 10);
                    }
                    if (this.ticks >= this.duration - 10) {
                        amethysm_purpleness = 1.0f - (float)(this.ticks - this.duration + 10) / 10.0f;
                    } else if (this.ticks >= 5) {
                        amethysm_purpleness = 1.0f;
                    }
                    ++this.ticks;
                } else {
                    this.running = false;
                    amethysm_whiteness = 0.0f;
                    amethysm_purpleness = 0.0f;
                }
            }
        }
    }

    public static class CenterHeartInfo {
        private float time = 0.0f;
        private float heartbeat_strength = 0.0f;
        private static final float HEARTBEAT_TIME = 5.0f;

        public void tick(float delta_tick_progress) {
            this.time += delta_tick_progress;
        }

        public void do_heartbeat(float strength) {
            if (!NineLifesConfig.heartbeat_enabled) {
                return;
            }
            this.time = 0.0f;
            this.heartbeat_strength = strength;
        }

        private float getCurrentStrength() {
            if (this.time > 5.0f) {
                return 0.0f;
            }
            if (this.time <= 2.5f) {
                return class_3532.method_16439((float)(this.time * 2.0f / 5.0f), (float)0.0f, (float)this.heartbeat_strength);
            }
            return class_3532.method_16439((float)((this.time - 2.5f) * 2.0f / 5.0f), (float)this.heartbeat_strength, (float)0.0f);
        }

        public class_243 getOffsetAndScale() {
            return new class_243(0.0, 0.0, (double)(1.0f + this.getCurrentStrength() / 20.0f));
        }
    }

    public static class DynamicQuestionMarkInfo {
        private static float lastAngle = 0.0f;
        private final Vector2d xy0p;
        private final Vector2d direction;
        private float time;
        private final int duration;

        public DynamicQuestionMarkInfo(float x0p, float y0p, Vector2d direction, int duration) {
            this.xy0p = new Vector2d((double)x0p, (double)y0p);
            this.direction = direction;
            this.time = 0.0f;
            this.duration = duration;
        }

        public DynamicQuestionMarkInfo(float x0p, float y0p, float speed, int duration) {
            this(x0p, y0p, new Vector2d(0.0), duration);
            float angle = new Random().nextFloat(0.0f, (float)Math.PI * 2);
            if ((double)lastAngle > Math.PI && (double)angle > Math.PI || (double)lastAngle < Math.PI && (double)angle < Math.PI) {
                angle = (float)(Math.PI * 2 - (double)angle);
            }
            lastAngle = angle;
            this.direction.x = Math.cos(angle) * 2.0 * (double)speed;
            this.direction.y = Math.sin(angle) * (double)speed;
        }

        private float getAlpha() {
            int FADE_IN = 30;
            int FADE_OUT = 10;
            float max_alpha = 0.5f;
            Function<Float, Float> clamp = a -> Float.valueOf(class_3532.method_16439((float)class_3532.method_15363((float)a.floatValue(), (float)0.0f, (float)1.0f), (float)0.0f, (float)0.5f));
            if (this.time <= 30.0f) {
                return clamp.apply(Float.valueOf(this.time / 30.0f)).floatValue();
            }
            if (this.time <= (float)(this.duration - 10)) {
                return 0.5f;
            }
            return clamp.apply(Float.valueOf(1.0f - (this.time - (float)this.duration + 10.0f) / 10.0f)).floatValue();
        }

        public float getOffset() {
            return class_3532.method_16439((float)(this.time / (float)this.duration), (float)0.0f, (float)5.0f);
        }

        public float getTime() {
            return this.time;
        }

        public int getDuration() {
            return this.duration;
        }

        public class_243 tick(float delta_tick_progress) {
            class_243 res = new class_243(this.direction.x, this.direction.y, 0.0).method_1021((double)(this.time / 20.0f)).method_1031(this.xy0p.x, this.xy0p.y, (double)this.getAlpha());
            this.time += delta_tick_progress;
            return res;
        }
    }
}

