/*
 * Decompiled with CFR 0.152.
 */
package com.bleudev.nine_lifes.mixin;

import com.bleudev.nine_lifes.custom.CustomEffects;
import com.bleudev.nine_lifes.interfaces.mixin.LivingEntityCustomInterface;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
implements LivingEntityCustomInterface {
    @Unique
    private class_2338 lastLightPos;
    @Unique
    private int damage_ticks = -1;

    @Shadow
    public abstract boolean method_6059(class_6880<class_1291> var1);

    @Override
    @Unique
    public void nine_lifes$setDamageTicks(int new_damage_ticks) {
        this.damage_ticks = new_damage_ticks;
    }

    @Override
    @Unique
    public int nine_lifes$getDamageTicks() {
        return this.damage_ticks;
    }

    @Inject(method={"readCustomData"}, at={@At(value="RETURN")})
    private void readDamageTicks(class_11368 view, CallbackInfo ci) {
        this.damage_ticks = view.method_71424("damage_ticks", -1);
    }

    @Inject(method={"writeCustomData"}, at={@At(value="RETURN")})
    private void writeDamageTicks(class_11372 view, CallbackInfo ci) {
        view.method_71465("damage_ticks", this.damage_ticks);
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    public void tick(CallbackInfo ci) {
        class_1309 entity = (class_1309)this;
        if (entity.method_73183().method_8608()) {
            return;
        }
        class_3218 serverWorld = (class_3218)entity.method_73183();
        boolean shouldLight = this.shouldEmitLight();
        int lightLevel = shouldLight ? 15 : 0;
        class_2338 footPos = entity.method_24515();
        List<class_2338> poses = List.of(footPos, footPos.method_10069(0, 1, 0));
        for (class_2338 pos : poses) {
            if (this.tryEmitLight(serverWorld, pos, lightLevel)) break;
        }
    }

    @Unique
    private void removeLightAt(class_3218 world, class_2338 pos) {
        if (world.method_8320(pos).method_27852(class_2246.field_31037)) {
            world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
        }
    }

    @Unique
    private boolean tryEmitLight(class_3218 serverWorld, class_2338 pos, int lightLevel) {
        if (this.lastLightPos != null && !this.lastLightPos.equals((Object)pos)) {
            this.removeLightAt(serverWorld, this.lastLightPos);
            this.lastLightPos = null;
        }
        if (lightLevel > 0) {
            class_2680 existing = serverWorld.method_8320(pos);
            if (existing.method_26215() || existing.method_27852(class_2246.field_31037)) {
                class_2680 lightState = (class_2680)class_2246.field_31037.method_9564().method_11657((class_2769)class_2741.field_12538, (Comparable)Integer.valueOf(lightLevel));
                serverWorld.method_8652(pos, lightState, 3);
                this.lastLightPos = pos;
                return true;
            }
        } else if (this.lastLightPos != null) {
            this.removeLightAt(serverWorld, this.lastLightPos);
            this.lastLightPos = null;
        }
        return false;
    }

    @Inject(method={"remove"}, at={@At(value="HEAD")})
    public void remove(class_1297.class_5529 reason, CallbackInfo ci) {
        class_1309 entity = (class_1309)this;
        if (!entity.method_73183().method_8608() && this.lastLightPos != null) {
            this.removeLightAt((class_3218)entity.method_73183(), this.lastLightPos);
            this.lastLightPos = null;
        }
    }

    @Unique
    private boolean shouldEmitLight() {
        return this.method_6059(CustomEffects.AMETHYSM) || this.method_6059((class_6880<class_1291>)class_1294.field_5912);
    }
}

