package com.bleudev.nine_lifes.custom;

import com.bleudev.nine_lifes.util.LivesUtils;
import com.bleudev.nine_lifes.util.TextUtils;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_11456;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

import static com.bleudev.nine_lifes.Nine_lifes.*;
import static net.minecraft.class_124.*;

public class CustomCommands {
    private record LinkData(String string, String link, class_124 color) {}

    private static final ArrayList<LinkData> links = new ArrayList<>();

    static {
        links.add(new LinkData("Github", GITHUB_LINK, field_1080));
        links.add(new LinkData("Modrinth", MODRINTH_LINK, field_1060));
    }

    private static class_5250 generateLinks() {
        class_5250 res = class_2561.method_43473();
        for (int i = 0; i < links.size(); i++) {
            var link = links.get(i);
            res = res.method_10852(class_2561.method_43470("- ").method_27692(field_1068));
            res = res.method_10852(TextUtils.literal_link(link.string, link.link).method_27692(link.color));
            if (i < links.size() - 1)
                res = res.method_27693("\n");
        }
        return res;
    }

    public static int nine_lifes(CommandContext<class_2168> context) {
        context.getSource().method_9226(() ->
            class_2561.method_43470(NAME + "\n").method_27692(field_1061).method_10852(
            class_2561.method_43469("commands.nl.text.author", AUTHOR).method_27692(field_1068)).method_27693("\n").method_10852(
            class_2561.method_43469("commands.nl.text.version", VERSION).method_27692(field_1068)).method_27693("\n\n").method_10852(
            class_2561.method_43471("commands.nl.text.links").method_27692(field_1068)).method_27693("\n").method_10852(generateLinks())
            ,false);
        return 1;
    }

    public static int nine_lifes_reset(CommandContext<class_2168> context) {
        LivesUtils.resetLives(context.getSource().method_44023());
        context.getSource().method_9226(() -> class_2561.method_43471("commands.nl.reset.success"), false);
        return 1;
    }
    public static int nine_lifes_reset_player(CommandContext<class_2168> context) {
        try {
            class_2186.method_9310(context, "players").forEach(player -> {
                LivesUtils.resetLives(player);
                context.getSource().method_9226(() -> class_2561.method_43469("commands.nl.reset.player.success", player.method_7334().name()), false);
            });
        } catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
        return 1;
    }

    public static int nine_lifes_set_lives(CommandContext<class_2168> context) {
        int lives = IntegerArgumentType.getInteger(context, "lives");
        LivesUtils.setLives(context.getSource().method_44023(), lives);
        context.getSource().method_9226(() -> class_2561.method_43469("commands.nl.set.success", lives), false);
        return 1;
    }
    public static int nine_lifes_set_lives_players(CommandContext<class_2168> context) {
        try {
            class_2186.method_9310(context, "players").forEach(player -> {
                int lives = IntegerArgumentType.getInteger(context, "lives");
                LivesUtils.setLives(player, lives);
                context.getSource().method_9226(() -> class_2561.method_43469("commands.nl.set.player.success", lives, player.method_7334().name()), false);
            });
        } catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
        return 1;
    }

    public static void initialize(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(class_2170
            .method_9247("nl").executes(CustomCommands::nine_lifes)
            .then(class_2170
                .method_9247("reset").executes(CustomCommands::nine_lifes_reset)
                .requires(class_11456::method_71775)
                .then(class_2170
                    .method_9244("players", class_2186.method_9308())
                    .executes(CustomCommands::nine_lifes_reset_player))
            )
            .then(class_2170
                .method_9247("set")
                .requires(class_11456::method_71775)
                .then(class_2170
                    .method_9244("lives", IntegerArgumentType.integer(1, 9))
                        .suggests((context, builder) -> {
                            builder.suggest(1);
                            builder.suggest(3);
                            builder.suggest(5);
                            builder.suggest(9);
                            return CompletableFuture.completedFuture(builder.build());
                        })
                    .executes(CustomCommands::nine_lifes_set_lives)
                    .then(class_2170
                        .method_9244("players", class_2186.method_9308())
                        .executes(CustomCommands::nine_lifes_set_lives_players))
        )));
    }
}
