/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.wikiful.api.event;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import dev.worldgen.wikiful.api.event.EventTriggerType;
import dev.worldgen.wikiful.api.registry.WikifulBuiltInRegistries;
import java.util.Optional;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.context.ContextKeySet;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public interface EventTrigger {
    public static final Codec<EventTrigger> CODEC = WikifulBuiltInRegistries.EVENT_TRIGGER_TYPE.byNameCodec().dispatch(EventTrigger::type, EventTriggerType::codec);

    public EventTriggerType<? extends EventTrigger> type();

    public static MapCodec<Optional<LootItemCondition>> conditionCodec(ContextKeySet contextKeySet) {
        return LootItemCondition.DIRECT_CODEC.validate(predicate -> {
            ProblemReporter.Collector collector = new ProblemReporter.Collector();
            ValidationContext validationContext = new ValidationContext((ProblemReporter)collector, contextKeySet);
            predicate.validate(validationContext);
            if (!collector.isEmpty()) {
                return DataResult.error(() -> "Validation error in event trigger condition: " + collector.getReport());
            }
            return DataResult.success((Object)predicate);
        }).optionalFieldOf("condition");
    }
}

