/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.wikiful.api.event;

import com.mojang.serialization.MapCodec;
import dev.worldgen.wikiful.api.event.EventTrigger;
import dev.worldgen.wikiful.api.registry.WikifulRegistries;
import dev.worldgen.wikiful.impl.event.TriggerHolder;
import dev.worldgen.wikiful.impl.event.UnlockedPages;
import dev.worldgen.wikiful.impl.event.UnlockedSections;
import dev.worldgen.wikiful.impl.event.UnlockedTips;
import dev.worldgen.wikiful.impl.event.triggers.AnyOf;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class EventTriggerType<T extends EventTrigger> {
    private final Map<Holder.Reference<TriggerHolder>, EventTrigger> listeners = new HashMap<Holder.Reference<TriggerHolder>, EventTrigger>();
    private final MapCodec<T> codec;

    public EventTriggerType(MapCodec<T> codec) {
        this.codec = codec;
    }

    public MapCodec<T> codec() {
        return this.codec;
    }

    public void clearListeners() {
        this.listeners.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addListener(Holder.Reference<TriggerHolder> holder, EventTrigger trigger) {
        Object list;
        if (!(trigger instanceof AnyOf)) {
            this.listeners.put(holder, trigger);
            return;
        }
        AnyOf anyOf = (AnyOf)trigger;
        try {
            list = anyOf.triggers();
            List<EventTrigger> triggers = list;
            list = triggers.iterator();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        while (list.hasNext()) {
            EventTrigger subtrigger = (EventTrigger)list.next();
            subtrigger.type().addListener(holder, subtrigger);
        }
    }

    public void onListeners(ServerPlayer player, Predicate<EventTrigger> matcher) {
        for (Map.Entry<Holder.Reference<TriggerHolder>, EventTrigger> listener : this.listeners.entrySet()) {
            EventTrigger trigger = listener.getValue();
            ResourceKey key = listener.getKey().key();
            ResourceLocation name = key.location();
            if (key.isFor(WikifulRegistries.TIP) && UnlockedTips.INSTANCE.hasUnlocked((Player)player, name) || key.isFor(WikifulRegistries.PAGE) && UnlockedPages.INSTANCE.hasUnlocked((Player)player, name) || key.isFor(WikifulRegistries.SECTION) && UnlockedSections.INSTANCE.hasUnlocked((Player)player, name) || !matcher.test(trigger)) continue;
            ((TriggerHolder)listener.getKey().value()).onTriggered(player, name);
        }
    }
}

