/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.wikiful.impl;

import dev.worldgen.wikiful.api.registry.WikifulBuiltInRegistries;
import dev.worldgen.wikiful.impl.registry.WikifulBodyTypes;
import dev.worldgen.wikiful.impl.registry.WikifulEventTriggerTypes;
import dev.worldgen.wikiful.impl.registry.WikifulLootParamSets;
import dev.worldgen.wikiful.impl.registry.WikifulWikiPageTypes;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Wikiful {
    public static final String MOD_ID = "wikiful";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"wikiful");

    public static void init() {
        WikifulBuiltInRegistries.init();
        WikifulEventTriggerTypes.init();
        WikifulWikiPageTypes.init();
        WikifulBodyTypes.init();
        WikifulLootParamSets.init();
    }

    public static ResourceLocation id(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)name);
    }

    public static <T> List<Holder.Reference<T>> getReferences(RegistryAccess registries, ResourceKey<Registry<T>> key) {
        return registries.lookupOrThrow(key).listElements().toList();
    }

    public static <T> List<Holder<T>> getHolders(RegistryAccess registries, ResourceKey<Registry<T>> key) {
        return registries.lookupOrThrow(key).listElements().map(reference -> reference).toList();
    }

    public static <T> List<T> getValues(RegistryAccess registries, ResourceKey<Registry<T>> key) {
        return registries.lookupOrThrow(key).stream().toList();
    }

    public static <T> List<Holder<T>> filterHolders(RegistryAccess registries, ResourceKey<Registry<T>> key, Predicate<Holder.Reference<T>> filter) {
        return registries.lookupOrThrow(key).listElements().filter(filter::test).map(holder -> holder).toList();
    }
}

